package org.alfresco.aos.dsl;

import org.alfresco.aos.AOSProperties;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.network.NetworkDrive;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

@Component
public class AOSNetworkDrive
{
    @Autowired
    AOSProperties aosProperties;

    @Autowired
    private DataUser dataUser;
    
    static Logger LOG = LogFactory.getLogger();

    static boolean secretAdded = false;

    public NetworkDrive inOSEnvironment() throws TestConfigurationException
    {
        if (SystemUtils.IS_OS_WINDOWS)
        {
            return winOS();
        }
        
        else if (SystemUtils.IS_OS_LINUX)
        {
            return linuxOS();
        }
        else if (SystemUtils.IS_OS_MAC) {
        	return macOS();
        }

        throw new TestConfigurationException("NetworkDrive was not configure YET for this Operating System. AOS will be mapped and run only on Windows and LINUX operating System so far. Please change your agent to run on a Windows/Linux Test Environments. Current tests are being executed on OS: " + SystemUtils.OS_NAME);
    }

    private NetworkDrive winOS()
    {

        return new NetworkDrive(dataUser.getAdminUser(), aosProperties.getAosWindowsNetwork(), "Y:")
        {

            @Override
            protected void umountCode() throws Exception
            {                
                /*
                 * cmd /c start /WAIT net use * /d /y
                 */
                runCommand("start /WAIT net use %s /d /y", "*");                
            }

            @Override
            protected void mountCode() throws Exception
            {                
                LOG.info(String.format("Mounting Windows drive on server = '%s' on local volume = '%s'", getServerNetworkPath(),
                        getLocalVolumePath()));
                /*
                 * cmd /c start /WAIT net use X: \\172.29.100.215:8080\alfresco\aos /user:admin admin /persistent:yes
                 */
                runCommand("start /WAIT net use %s %s /user:%s %s /persistent:yes", 
                                    getLocalVolumePath(), 
                                    getServerNetworkPath(),
                                    getUserForNetworkAccess().getUsername(),
                                    getUserForNetworkAccess().getPassword());
            }
        };
    }
    
    private NetworkDrive linuxOS()
    {
        return new NetworkDrive(dataUser.getAdminUser(), aosProperties.getAosLinuxNetwork(), "/mnt/alfrescoAos")
        {

            @Override
            protected void umountCode() throws Exception
            {                
                // umount -t davfs /home/aos
                runCommand("sudo umount -t davfs -l %s", getLocalVolumePath());
                Utility.waitToLoopTime(20, "until AOS umount is complete!");
                runCommand("sudo rm -rf %s", getLocalVolumePath());                
            }

            @Override
            protected void mountCode() throws Exception
            {
                if(!secretAdded) {
                    LOG.info(String.format("Adding the Secret for DAVFS on server = '%s'", getServerNetworkPath()));
                    runCommand("echo '%s %s %s' | sudo tee /etc/davfs2/secrets",
                            aosProperties.getAosLinuxNetwork(),
                            getUserForNetworkAccess().getUsername(),
                            getUserForNetworkAccess().getPassword());
                    secretAdded = true;
                }

                LOG.info(String.format("Mounting Linux drive using DAVFS on server = '%s' on local volume = '%s'", getServerNetworkPath(),
                        getLocalVolumePath()));
                runCommand("sudo mkdir -p " + getLocalVolumePath());
                runCommand("sudo mount -t davfs %s %s -o rw -o uid=travis,gid=travis,file_mode=0777,dir_mode=0777",
                        aosProperties.getAosLinuxNetwork(),
                        getLocalVolumePath());
                runCommand(String.format("sudo chmod 777 -R %s", getLocalVolumePath()));
                Utility.waitToLoopTime(20, "until AOS mounting is complete!");
            }
        };
    }
    
    private NetworkDrive macOS()
    {
        return new NetworkDrive(dataUser.getAdminUser(), aosProperties.getAosLinuxNetwork(), "/data/alfrescoAos")
        {

            @Override
            protected void umountCode() throws Exception
            {                
//                // diskutil unmount force /data/aos
//                runCommand("diskutil unmount force %s", getLocalVolumePath());
//                runCommand("rm -rf %s", getLocalVolumePath());                
            }

            @Override
            protected void mountCode() throws Exception
            {   
//                LOG.info(String.format("Mac: Mounting AOS using DAVFS: server = '%s' on local volume = '%s'", getServerNetworkPath(),
//                        getLocalVolumePath()));
//                runCommand("mkdir -p " + getLocalVolumePath());                
//                // mount -t davfs http://vsphered7.qa.internal.alfresco.com:8070/alfresco/aos /home/aos/ -o username=admin <<< 'admin'
//                runCommand("mount -t davfs %s %s -o username=%s <<< '%s'", 
//                                    aosProperties.getAosLinuxNetwork(), 
//                                    getLocalVolumePath(),
//                                    getUserForNetworkAccess().getUsername(),
//                                    getUserForNetworkAccess().getPassword());
//                                
//                runCommand(String.format("sudo chmod o+rw -R %s", getLocalVolumePath()));
//                
//                Utility.waitToLoopTime(20, "until AOS mounting is complete...");
            }
        };
    }
}