package org.alfresco.aos.web;

import org.alfresco.utility.web.HtmlPage;
import org.alfresco.utility.web.annotation.PageObject;
import org.alfresco.utility.web.annotation.RenderWebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/**
 * 
 * @author Cristina Axinte
 *
 */
@PageObject
public class AosNavigationPage extends HtmlPage
{
    @RenderWebElement
    @FindBy(css = "table[class='listTable']")
    private WebElement navigationTable;
    
    @FindBy(css = "tr>td>a")
    private WebElement tableRow;
    
    /**
     * Click login button
     */
    public void clickTableRow(String contentName)
    {
        navigationTable.findElement(By.xpath(String.format("//tr/td/a[contains(text(),'%s')]", contentName))).click();
    }

}
