/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package demo;

import java.net.URI;

import org.alfresco.officeservices.testclient.RestApiClient;
import org.alfresco.officeservices.testclient.office.Office2003WindowsXPClient;
import org.alfresco.officeservices.testclient.office.Office2007WindowsXPClient;
import org.alfresco.officeservices.testclient.office.Office2010Windows7Client;
import org.alfresco.officeservices.testclient.office.OfficeClientMessageReceiver;
import org.alfresco.officeservices.testclient.office.OfficeFileHandle;
import org.junit.BeforeClass;
import org.junit.Test;

public class DemoOfficeClientsIT implements OfficeClientMessageReceiver
{
    
    private static String USERNAME = "admin";
    
    private static String PASSWORD = "admin";

    private static String BASE_HOST = "http://localhost:8080";
    private static String BASE_URI = BASE_HOST + "/alfresco/aos";
    
    //private static String DMSID_ENC = "ocmis%2C03f6900c-36f2-4698-bec5-b30b6a7d7a8c%2Cworkspace%3A%7C%7CSpacesStore%7Ce380dc23-45c1-4550-b1e4-0f4aed0ece54$3B1.0";
    
    private static String DOCUMENT_NAME;

    public void message(String msg)
    {
        System.out.println(msg);
    }

    @BeforeClass
    public static void createTestData()
    {
        RestApiClient restApiClient = new RestApiClient(BASE_HOST);
        DOCUMENT_NAME = restApiClient.createFileFromExisting(USERNAME, PASSWORD, "files/file.doc");
    }

    @Test
    public void testRunOffice2003OnWindowsXP() throws Exception
    {
        Office2003WindowsXPClient officeClient = new Office2003WindowsXPClient(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI+"/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI+"/"+DOCUMENT_NAME/*+"_"+DMSID_ENC+"/"+DOCUMENT_NAME*/));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh,"comment",false);
        officeClient.closeFile(ofh);
    }
    
    @Test
    public void testRunOffice2007OnWindowsXP() throws Exception
    {
        Office2007WindowsXPClient officeClient = new Office2007WindowsXPClient(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI+"/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI+"/"+DOCUMENT_NAME/*+"_"+DMSID_ENC+"/"+DOCUMENT_NAME*/));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh,"comment",false);
        //officeClient.closeFile(ofh);
    }

    @Test
    public void testRunOffice2010OnWindows7() throws Exception
    {
        Office2010Windows7Client officeClient = new Office2010Windows7Client(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI+"/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI+"/"+DOCUMENT_NAME/*+"_"+DMSID_ENC+"/"+DOCUMENT_NAME*/));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh,"comment",false);
        //officeClient.closeFile(ofh);
    }

}
