/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.io.IOException;
import java.io.InputStream;

import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;

public class FPSEResponse
{

    protected FPSEResponseElement topElement = new FPSEResponseElement();
    
    public FPSEResponse(InputStream in) throws ServiceCommunicationException, ServiceResponseException
    {
        try
        {
            PushbackLineReader plr = new PushbackLineReader(in);
            readMessage(plr);
        }
        catch(IOException ioe)
        {
            throw new ServiceCommunicationException(ioe);
        }
    }
    
    public FPSEResponseElement getTopElement()
    {
        return topElement;
    }
    
    protected void readMessage(PushbackLineReader plr) throws IOException, ServiceResponseException
    {
        if(!plr.readLine().equals("<html><head><title>vermeer RPC packet</title></head>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        if(!plr.readLine().equals("<body>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        readTopElement(plr);
        if(!plr.readLine().equals("</body>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        if(!plr.readLine().equals("</html>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
    }
    
    protected void readTopElement(PushbackLineReader plr) throws IOException, ServiceResponseException
    {
        while(true)
        {
            String line = plr.readLine();
            if(line.equals("</body>"))
            {
                plr.pushBack(line);
                break;
            }
            if(!line.startsWith("<p>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            line = line.substring(3);
            int sepPos = line.indexOf('=');
            if(sepPos==-1)
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            String name = line.substring(0,sepPos);
            String value = line.substring(sepPos+1,line.length());
            // sneak preview next line to detect sub elements
            String nextLine = plr.readLine();
            plr.pushBack(nextLine);
            if(nextLine.equals("<ul>"))
            {
                if(!(value.length()==0))
                {
                    throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
                }
                FPSEResponseElement subElement = new FPSEResponseElement();
                if(name.equals("meta_info"))
                {
                    readMetaInfoElement(subElement,plr);
                }
                else if(name.equals("failedUrls"))
                {
                    readSubList(subElement,plr);
                }
                else
                {
                    readSubElement(subElement,plr);
                }
                topElement.addElement(name, subElement);
            }
            else
            {
                topElement.addElement(name, new FPSEResponseElement(value));
            }
        }
    }
    
    protected void readSubElement(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException
    {
        if(!plr.readLine().equals("<ul>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        while(true)
        {
            String line = plr.readLine();
            if(line.equals("</ul>"))
            {
                break;
            }
            if(line.equals("<ul>"))
            {
                // anonymous list
                plr.pushBack(line);
                FPSEResponseElement anonymousListElement = new FPSEResponseElement();
                readSubElement(anonymousListElement,plr);
                subElement.addAnonymousList(anonymousListElement);
                continue;
            }
            if(!line.startsWith("<li>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            line = line.substring(4);
            int sepPos = line.indexOf('=');
            if(sepPos==-1)
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            String name = line.substring(0,sepPos);
            if(sepPos == line.length()-1)
            {
                FPSEResponseElement subSubElement = new FPSEResponseElement();
                if(name.equals("meta_info"))
                {
                    readMetaInfoElement(subSubElement,plr);
                }
                else
                {
                    readSubElement(subSubElement,plr);
                }
                subElement.addElement(name, subSubElement);
            }
            else
            {
                String value = line.substring(sepPos+1,line.length());
                subElement.addElement(name, new FPSEResponseElement(value));
            }
        }
    }
    
    protected void readMetaInfoElement(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException
    {
        if(!plr.readLine().equals("<ul>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        while(true)
        {
            String line1 = plr.readLine();
            if(line1.equals("</ul>"))
            {
                break;
            }
            if(!line1.startsWith("<li>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            String line2 = plr.readLine();
            if(line2.equals("</ul>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            if(!line2.startsWith("<li>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            subElement.addElement(line1.substring(4), new FPSEResponseElement(line2.substring(4)));
        }
    }
    
    protected void readSubList(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException
    {
        if(!plr.readLine().equals("<ul>"))
        {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
        }
        while(true)
        {
            String line = plr.readLine();
            if(line.equals("</ul>"))
            {
                break;
            }
            if(!line.startsWith("<li>"))
            {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line "+plr.getLineNumber());
            }
            line = line.substring(4);
            subElement.addListItem(line);
        }
    }

}
