/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPSEResponseElement
{

    protected boolean isSingleValue;
    
    protected Map<String,FPSEResponseElement> subElements;
    
    protected ArrayList<FPSEResponseElement> anonymousLists;
    
    protected ArrayList<String> multiValues;
    
    protected String value;
    
    public FPSEResponseElement(String val)
    {
        isSingleValue = true;
        value = val;
    }
    
    public FPSEResponseElement()
    {
        isSingleValue = false;
        subElements = new HashMap<String,FPSEResponseElement>();
    }
    
    public void addElement(String name, FPSEResponseElement element)
    {
        if(isSingleValue)
        {
            throw new IllegalStateException("can not add sub-elements to single valued element.");
        }
        subElements.put(name, element);
    }
    
    public String getValue()
    {
        if(!isSingleValue)
        {
            throw new IllegalStateException("can not get value of list.");
        }
        return value;
    }
    
    public FPSEResponseElement getSubElement(String name)
    {
        if(isSingleValue)
        {
            throw new IllegalStateException("can not get sub-element of single valued element.");
        }
        return subElements.get(name);
    }

    public void addAnonymousList(FPSEResponseElement anonymousListElement)
    {
        if(anonymousLists == null)
        {
            anonymousLists = new ArrayList<FPSEResponseElement>();
        }
        anonymousLists.add(anonymousListElement);
    }
    
    public ArrayList<FPSEResponseElement> getAnonymousLists()
    {
        return anonymousLists;
    }

    public void addListItem(String item)
    {
        if(multiValues == null)
        {
            multiValues = new ArrayList<String>();
        }
        multiValues.add(item);
    }
    
    public List<String> getMultiValues()
    {
        return multiValues;
    }
    
}
