/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.officeservices.testclient.AoserviceClientMessageReceiver;
import org.alfresco.officeservices.testclient.HttpLock;
import org.alfresco.officeservices.testclient.HttpPropfind;
import org.alfresco.officeservices.testclient.HttpUnlock;
import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;
import org.alfresco.officeservices.testclient.fpse.FPSERequest;
import org.alfresco.officeservices.testclient.fpse.FPSEResponse;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.alfresco.officeservices.testclient.util.URLEncoder;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AoservicesClient {
    protected static URLEncoder urlEncoder = new URLEncoder();
    protected DefaultHttpClient httpClient = new DefaultHttpClient();
    protected CookieStore cookieStore = null;
    protected AoserviceClientMessageReceiver messageReceiver = null;

    public AoservicesClient(String username, String password) {
        if (username != null) {
            this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        this.cookieStore = new BasicCookieStore();
        this.httpClient.setCookieStore(this.cookieStore);
    }

    public void addCookie(Cookie cookie) {
        this.cookieStore.addCookie(cookie);
    }

    public void setMessageReceiver(AoserviceClientMessageReceiver receiver) {
        this.messageReceiver = receiver;
    }

    protected void emitMessage(String msg) {
        if (this.messageReceiver != null) {
            this.messageReceiver.message(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VTI_INF_VERSION getVtiInformation(URI target) throws ServiceCommunicationException, ServiceResponseException {
        byte[] vtiInf;
        CloseableHttpResponse serviceResponse;
        URI vtiInfUri;
        try {
            vtiInfUri = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)"/_vti_inf.html", null, null);
            HttpGet vtiInfGet = new HttpGet(vtiInfUri);
            serviceResponse = this.httpClient.execute((HttpUriRequest)vtiInfGet);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        if (serviceResponse.getStatusLine().getStatusCode() != 200) {
            if (serviceResponse.getStatusLine().getStatusCode() == 404) {
                throw new ServiceResponseException("The service information file is missing. URI=" + String.valueOf(vtiInfUri));
            }
            throw new ServiceResponseException("Unknow error getting the service information file. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(vtiInfUri));
        }
        HttpEntity vtiInfEntity = serviceResponse.getEntity();
        if (vtiInfEntity == null) {
            throw new ServiceResponseException("The request for the service information file does not return a Entity. URI=" + String.valueOf(vtiInfUri));
        }
        try (InputStream in = vtiInfEntity.getContent();){
            vtiInf = AoservicesClient.streamToByteArray(in);
        }
        catch (IOException ioe) {
            throw new ServiceCommunicationException(ioe);
        }
        byte[] sampleVer6 = AoservicesClient.getResourceAsByteArray("org/alfresco/aoservices/testclient/resources/vtiinf.wss2");
        byte[] sampleVer12 = AoservicesClient.getResourceAsByteArray("org/alfresco/aoservices/testclient/resources/vtiinf.wss3");
        byte[] sampleVer14 = AoservicesClient.getResourceAsByteArray("org/alfresco/aoservices/testclient/resources/vtiinf.ver14");
        byte[] sampleVer15 = AoservicesClient.getResourceAsByteArray("org/alfresco/aoservices/testclient/resources/vtiinf.ver15");
        if (AoservicesClient.arrayCompare(vtiInf, sampleVer6)) {
            return VTI_INF_VERSION.VER6;
        }
        if (AoservicesClient.arrayCompare(vtiInf, sampleVer12)) {
            return VTI_INF_VERSION.VER12;
        }
        if (AoservicesClient.arrayCompare(vtiInf, sampleVer14)) {
            return VTI_INF_VERSION.VER14;
        }
        return VTI_INF_VERSION.VER15;
    }

    public boolean options(URI target, OptionsHeaderValidation headerValidation) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse = null;
        for (int maxRepeat = 1; maxRepeat >= 0; --maxRepeat) {
            try {
                HttpOptions options = new HttpOptions(target);
                serviceResponse = this.httpClient.execute((HttpUriRequest)options);
                serviceResponse.getEntity().getContent().close();
            }
            catch (Exception e) {
                throw new ServiceCommunicationException(e);
            }
            if (serviceResponse.getStatusLine().getStatusCode() != 302) break;
            String location = AoservicesClient.getHeaderValue((HttpResponse)serviceResponse, "Location", true);
            this.emitMessage("Redirected from " + target.toString() + " to " + location);
            if (!location.startsWith(target.toString())) {
                throw new ServiceCommunicationException("Invalid 302 redirect");
            }
            try {
                target = new URI(location);
                continue;
            }
            catch (URISyntaxException e) {
                throw new ServiceCommunicationException(e);
            }
        }
        if (headerValidation != OptionsHeaderValidation.NONE) {
            this.checkForRequiredHeaders((HttpResponse)serviceResponse, headerValidation == OptionsHeaderValidation.ALL);
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        throw new ServiceResponseException("Invalid response getting options. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(target));
    }

    public boolean propfind(URI target) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse = null;
        for (int maxRepeat = 1; maxRepeat >= 0; --maxRepeat) {
            try {
                HttpPropfind propfind = new HttpPropfind(target);
                serviceResponse = this.httpClient.execute((HttpUriRequest)propfind);
                serviceResponse.getEntity().getContent().close();
            }
            catch (Exception e) {
                throw new ServiceCommunicationException(e);
            }
            if (serviceResponse.getStatusLine().getStatusCode() != 302) break;
            String location = AoservicesClient.getHeaderValue((HttpResponse)serviceResponse, "Location", true);
            this.emitMessage("Redirected from " + target.toString() + " to " + location);
            if (!location.startsWith(target.toString())) {
                throw new ServiceCommunicationException("Invalid 302 redirect");
            }
            try {
                target = new URI(location);
                continue;
            }
            catch (URISyntaxException e) {
                throw new ServiceCommunicationException(e);
            }
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 207) {
            return true;
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        throw new ServiceResponseException("Invalid response getting properties. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lock(URI target, String currentLockToken) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse = null;
        try {
            HttpLock lock = new HttpLock(target);
            if (currentLockToken != null) {
                lock.setHeader("If", "(<" + currentLockToken + ">)");
            }
            serviceResponse = this.httpClient.execute((HttpUriRequest)lock);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() != 200) {
            throw new ServiceResponseException("Invalid LOCK response. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(target));
        }
        HttpEntity responseEntity = serviceResponse.getEntity();
        if (responseEntity == null) {
            throw new ServiceResponseException("FPSE request does not return a Entity.");
        }
        Document xmlResponse = null;
        try (InputStream in = responseEntity.getContent();){
            try {
                xmlResponse = this.getDocumentFromStream(in);
            }
            catch (DocumentException e) {
                throw new ServiceResponseException("Error reading soap response.");
            }
        }
        catch (IOException ioe) {
            throw new ServiceCommunicationException(ioe);
        }
        Element propElem = xmlResponse.getRootElement();
        Element lockdiscoveryElem = propElem.element("lockdiscovery");
        Element activelockElem = lockdiscoveryElem.element("activelock");
        Element locktokenElem = activelockElem.element("locktoken");
        Element hrefElem = locktokenElem.element("href");
        return hrefElem.getText();
    }

    public void unlock(URI target, String currentLockToken) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse = null;
        try {
            HttpUnlock unlock = new HttpUnlock(target);
            unlock.setHeader("Lock-Token", "<" + currentLockToken + ">");
            serviceResponse = this.httpClient.execute((HttpUriRequest)unlock);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() != 204) {
            throw new ServiceResponseException("Invalid UNLOCK response. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FPSEResponse execute(FPSERequest request) throws ServiceCommunicationException, ServiceResponseException {
        FPSEResponse fPSEResponse;
        CloseableHttpResponse serviceResponse;
        try {
            HttpPost fpsePost = new HttpPost(request.getServiceEndpoint());
            fpsePost.setEntity((HttpEntity)request.getRequestEntity());
            fpsePost.setHeader("MIME-Version", "1.0");
            fpsePost.setHeader("User-Agent", "MSFrontPage/6.0");
            fpsePost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            fpsePost.setHeader("X-Vermeer-Content-Type", "application/x-www-form-urlencoded");
            serviceResponse = this.httpClient.execute((HttpUriRequest)fpsePost);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, false);
        if (serviceResponse.getStatusLine().getStatusCode() != 200) {
            throw new ServiceResponseException("Invalid response to FPSE request. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(request.getServiceEndpoint()));
        }
        HttpEntity responseEntity = serviceResponse.getEntity();
        if (responseEntity == null) {
            throw new ServiceResponseException("FPSE request does not return a Entity.");
        }
        InputStream in = responseEntity.getContent();
        try {
            FPSEResponse response = new FPSEResponse(in);
            FPSEResponseElement statusElement = response.getTopElement().getSubElement("status");
            if (statusElement != null) {
                FPSEResponseElement msgElement = statusElement.getSubElement("msg");
                Object exceptionMsg = "Service returned error.";
                if (msgElement != null) {
                    exceptionMsg = (String)exceptionMsg + " (" + msgElement.getValue() + ")";
                }
                throw new ServiceResponseException((String)exceptionMsg);
            }
            fPSEResponse = response;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ServiceCommunicationException(ioe);
            }
        }
        in.close();
        return fPSEResponse;
    }

    public FPSEVersion getFPSEVersion(URI target) throws ServiceCommunicationException, ServiceResponseException {
        URI vtiBinUri;
        try {
            vtiBinUri = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)"/_vti_bin/shtml.dll/_vti_rpc", null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest serverVersionRequest = new FPSERequest(vtiBinUri, "server version", "6.0.2.8164");
        FPSEResponse serverVersionResponse = this.execute(serverVersionRequest);
        FPSEVersion ver = new FPSEVersion();
        FPSEResponseElement rootElement = serverVersionResponse.getTopElement();
        FPSEResponseElement sourceControlElement = this.getMandatoryElement(rootElement, "source control");
        if (!sourceControlElement.getValue().equals("1")) {
            throw new ServiceResponseException("invalid source control flag");
        }
        FPSEResponseElement serverVersionElement = this.getMandatoryElement(rootElement, "server version");
        FPSEResponseElement majorElement = this.getMandatoryElement(serverVersionElement, "major ver");
        FPSEResponseElement minorElement = this.getMandatoryElement(serverVersionElement, "minor ver");
        FPSEResponseElement phaseElement = this.getMandatoryElement(serverVersionElement, "phase ver");
        FPSEResponseElement verIncrElement = this.getMandatoryElement(serverVersionElement, "ver incr");
        try {
            ver.major = Integer.parseInt(majorElement.getValue());
            ver.minor = Integer.parseInt(minorElement.getValue());
            ver.phase = Integer.parseInt(phaseElement.getValue());
            ver.increase = Integer.parseInt(verIncrElement.getValue());
        }
        catch (Exception e) {
            throw new ServiceResponseException("error decoding server version");
        }
        return ver;
    }

    public FPSEUrlToWebUrl getFPSEUrlToWebUrl(URI target) throws ServiceCommunicationException, ServiceResponseException {
        URI vtiBinUri;
        try {
            vtiBinUri = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)"/_vti_bin/shtml.dll/_vti_rpc", null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest serverVersionRequest = new FPSERequest(vtiBinUri, "url to web url", "6.0.2.8164");
        serverVersionRequest.addParameter("url", target.getPath());
        serverVersionRequest.addParameter("flags", "0");
        FPSEResponse serverVersionResponse = this.execute(serverVersionRequest);
        FPSEUrlToWebUrl urlToWebUrl = new FPSEUrlToWebUrl();
        FPSEResponseElement rootElement = serverVersionResponse.getTopElement();
        urlToWebUrl.webUrl = StringEscapeUtils.unescapeHtml4((String)this.getMandatoryElement(rootElement, "webUrl").getValue());
        urlToWebUrl.fileUrl = StringEscapeUtils.unescapeHtml4((String)this.getMandatoryElement(rootElement, "fileUrl").getValue());
        if (urlToWebUrl.fileUrl.length() > 0) {
            String reconstructed = urlToWebUrl.webUrl + "/" + urlToWebUrl.fileUrl;
            if (!reconstructed.equals(target.getPath())) {
                throw new ServiceResponseException("invalid urlTowebUrl split");
            }
        } else {
            String compareTo = target.getPath();
            if (compareTo.length() > 1 && compareTo.charAt(compareTo.length() - 1) == '/') {
                compareTo = compareTo.substring(0, compareTo.length() - 1);
            }
            if (!urlToWebUrl.webUrl.equals(compareTo)) {
                throw new ServiceResponseException("invalid urlTowebUrl split");
            }
        }
        try {
            urlToWebUrl.fpseEndpoint = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)urlToWebUrl.webUrl, null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        return urlToWebUrl;
    }

    public FPSEResponseElement getFPSEOpenService(URI serviceEndpoint) throws ServiceCommunicationException, ServiceResponseException {
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest openServiceRequest = new FPSERequest(authorUri, "open service", "6.0.2.8164");
        openServiceRequest.addParameter("name", serviceEndpoint.getPath());
        FPSEResponse openServiceResponse = this.execute(openServiceRequest);
        FPSEResponseElement rootElement = openServiceResponse.getTopElement();
        FPSEResponseElement serviceElement = this.getMandatoryElement(rootElement, "service");
        if (!this.getMandatoryElement(serviceElement, "service_name").getValue().equals(serviceEndpoint.getPath())) {
            throw new ServiceResponseException("invalid service name in open service response");
        }
        return this.getMandatoryElement(serviceElement, "meta_info");
    }

    public FPSEGetDocsMetaInfo getFPSEGetDocsMetaInfo(URI serviceEndpoint, List<String> targets) throws ServiceCommunicationException, ServiceResponseException {
        ArrayList<FPSEResponseElement> document_listList;
        FPSEResponseElement document_listElement;
        ArrayList<FPSEResponseElement> urldirsList;
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest getDocsMetaInfoRequest = new FPSERequest(authorUri, "getDocsMetaInfo", "6.0.2.8164");
        StringBuilder url_list = new StringBuilder();
        url_list.append('[');
        for (int i = 0; i < targets.size(); ++i) {
            if (i > 0) {
                url_list.append(';');
            }
            url_list.append(targets.get(i));
        }
        url_list.append(']');
        getDocsMetaInfoRequest.addParameter("url_list", url_list.toString());
        getDocsMetaInfoRequest.addParameter("listHiddenDocs", "false");
        getDocsMetaInfoRequest.addParameter("listLinkInfo", "false");
        FPSEResponse getDocsMetaInfoResponse = this.execute(getDocsMetaInfoRequest);
        FPSEGetDocsMetaInfo getDocsMetaInfo = new FPSEGetDocsMetaInfo();
        FPSEResponseElement rootElement = getDocsMetaInfoResponse.getTopElement();
        FPSEResponseElement urldirsElement = rootElement.getSubElement("urldirs");
        if (urldirsElement != null && (urldirsList = urldirsElement.getAnonymousLists()) != null) {
            for (FPSEResponseElement urldirElement : urldirsList) {
                String url = this.getMandatoryElement(urldirElement, "url").getValue();
                FPSEResponseElement metaInfo = this.getMandatoryElement(urldirElement, "meta_info");
                getDocsMetaInfo.urldirs.put(url, metaInfo);
            }
        }
        if ((document_listElement = rootElement.getSubElement("document_list")) != null && (document_listList = document_listElement.getAnonymousLists()) != null) {
            for (FPSEResponseElement documentElement : document_listList) {
                String document_name = this.getMandatoryElement(documentElement, "document_name").getValue();
                FPSEResponseElement metaInfo = this.getMandatoryElement(documentElement, "meta_info");
                getDocsMetaInfo.document_list.put(document_name, this.getFileStatusFromMetaInfo(metaInfo));
            }
        }
        return getDocsMetaInfo;
    }

    public FileStatus getFPSEGetDocument(URI serviceEndpoint, String fileUrl) throws ServiceCommunicationException, ServiceResponseException {
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest getDocumentRequest = new FPSERequest(authorUri, "get document", "6.0.2.8164");
        getDocumentRequest.addParameter("service_name", serviceEndpoint.getPath());
        getDocumentRequest.addParameter("document_name", fileUrl);
        getDocumentRequest.addParameter("old_theme_html", "false");
        getDocumentRequest.addParameter("force", "false");
        getDocumentRequest.addParameter("get_option", "chkoutExclusive");
        getDocumentRequest.addParameter("doc_version", "");
        getDocumentRequest.addParameter("timeout", "10");
        FPSEResponse getDocumentResponse = this.execute(getDocumentRequest);
        FPSEResponseElement rootElement = getDocumentResponse.getTopElement();
        FPSEResponseElement documentElement = this.getMandatoryElement(rootElement, "document");
        return this.getFileStatusFromMetaInfo(this.getMandatoryElement(documentElement, "meta_info"));
    }

    public FileStatus getFPSECheckoutDocument(URI serviceEndpoint, String fileUrl, int timeout) throws ServiceCommunicationException, ServiceResponseException {
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest checkoutDocumentRequest = new FPSERequest(authorUri, "checkout document", "6.0.2.8164");
        checkoutDocumentRequest.addParameter("service_name", serviceEndpoint.getPath());
        checkoutDocumentRequest.addParameter("document_name", fileUrl);
        checkoutDocumentRequest.addParameter("force", timeout == 0 ? "1" : "2");
        checkoutDocumentRequest.addParameter("timeout", Integer.toString(timeout));
        FPSEResponse checkoutDocumentResponse = this.execute(checkoutDocumentRequest);
        FPSEResponseElement rootElement = checkoutDocumentResponse.getTopElement();
        return this.getFileStatusFromMetaInfo(this.getMandatoryElement(rootElement, "meta_info"));
    }

    public FileStatus getFPSEUncheckoutDocument(URI serviceEndpoint, String fileUrl, boolean rlsshortterm) throws ServiceCommunicationException, ServiceResponseException {
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest uncheckoutDocumentRequest = new FPSERequest(authorUri, "uncheckout document", "6.0.2.8164");
        uncheckoutDocumentRequest.addParameter("service_name", serviceEndpoint.getPath());
        uncheckoutDocumentRequest.addParameter("document_name", fileUrl);
        uncheckoutDocumentRequest.addParameter("force", "false");
        uncheckoutDocumentRequest.addParameter("rlsshortterm", rlsshortterm ? "true" : "false");
        FPSEResponse checkoutDocumentResponse = this.execute(uncheckoutDocumentRequest);
        FPSEResponseElement rootElement = checkoutDocumentResponse.getTopElement();
        return this.getFileStatusFromMetaInfo(this.getMandatoryElement(rootElement, "meta_info"));
    }

    public FileStatus getFPSECheckinDocument(URI serviceEndpoint, String fileUrl, String comment) throws ServiceCommunicationException, ServiceResponseException {
        URI authorUri;
        try {
            authorUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/_vti_aut/author.dll"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        FPSERequest checkinDocumentRequest = new FPSERequest(authorUri, "checkin document", "6.0.2.8164");
        checkinDocumentRequest.addParameter("service_name", serviceEndpoint.getPath());
        checkinDocumentRequest.addParameter("document_name", fileUrl);
        checkinDocumentRequest.addParameter("comment", comment);
        checkinDocumentRequest.addParameter("keep_checked_out", "false");
        FPSEResponse checkoutDocumentResponse = this.execute(checkinDocumentRequest);
        FPSEResponseElement rootElement = checkoutDocumentResponse.getTopElement();
        return this.getFileStatusFromMetaInfo(this.getMandatoryElement(rootElement, "meta_info"));
    }

    public FileStatus getFileStatusFromMetaInfo(FPSEResponseElement metaInfo) throws ServiceResponseException {
        FileStatus fs = new FileStatus();
        fs.metaInfo = metaInfo;
        if (metaInfo.getSubElement("vti_sourcecontrolcheckedoutby") != null) {
            String username = metaInfo.getSubElement("vti_sourcecontrolcheckedoutby").getValue();
            if (!username.startsWith("SR|")) {
                throw new ServiceResponseException("invalid checkout username format");
            }
            username = username.substring(3);
            fs.lockUser = username = username.replace("&#92;", "\\");
            fs.lockState = metaInfo.getSubElement("vti_sourcecontrollockexpires") != null ? LockState.LOCKED : LockState.CHECKEDOUT;
        } else {
            fs.lockState = LockState.NONE;
            fs.lockUser = null;
        }
        return fs;
    }

    public boolean doHead(URI target) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse;
        try {
            HttpHead head = new HttpHead(target);
            serviceResponse = this.httpClient.execute((HttpUriRequest)head);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        throw new ServiceResponseException("Invalid response for web form existance. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " target=" + String.valueOf(target));
    }

    public boolean testWebFormExistence(URI serviceEndpoint, String location, DialogType type) throws ServiceCommunicationException, ServiceResponseException {
        URI webFormUri = null;
        try {
            webFormUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/owssvr.dll?location=" + urlEncoder.encode(location) + "&dialogview=" + String.valueOf((Object)type)), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        return this.doHead(webFormUri);
    }

    public boolean getWebForm(URI serviceEndpoint, String location, DialogType type, String filter) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse;
        try {
            if (filter == null) {
                filter = "*.*;";
            }
            URI webFormUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/owssvr.dll?location=" + urlEncoder.encode(location) + "&dialogview=" + String.valueOf((Object)type) + "&FileDialogFilterValue=" + filter), null, null);
            HttpGet webFormGet = new HttpGet(webFormUri);
            serviceResponse = this.httpClient.execute((HttpUriRequest)webFormGet);
            serviceResponse.getEntity().getContent().close();
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        throw new ServiceResponseException("Invalid response for web form existance. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(serviceEndpoint));
    }

    public boolean get(URI target) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse;
        try {
            HttpGet get = new HttpGet(target);
            serviceResponse = this.httpClient.execute((HttpUriRequest)get);
            serviceResponse.getEntity().getContent().close();
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() == 200) {
            return true;
        }
        if (serviceResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        throw new ServiceResponseException("Invalid response for web form existance. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean soapCheckout(URI serviceEndpoint, URI target, boolean checkoutToLocal) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse;
        URI listsUri;
        try {
            listsUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/lists.asmx"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        StringBuilder soapRequest = new StringBuilder();
        soapRequest.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        soapRequest.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        soapRequest.append("<soap:Body>");
        soapRequest.append("<CheckOutFile xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        soapRequest.append("<pageUrl>");
        soapRequest.append(target.toString());
        soapRequest.append("</pageUrl>");
        soapRequest.append("<checkoutToLocal>");
        soapRequest.append(checkoutToLocal ? "true" : "false");
        soapRequest.append("</checkoutToLocal>");
        soapRequest.append("<lastmodified>02 Jul 2011 17:25:58 -0000</lastmodified>");
        soapRequest.append("</CheckOutFile>");
        soapRequest.append("</soap:Body>");
        soapRequest.append("</soap:Envelope>");
        try {
            HttpPost soapPost = new HttpPost(listsUri);
            soapPost.setEntity((HttpEntity)new StringEntity(soapRequest.toString(), "text/xml", "UTF-8"));
            soapPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            soapPost.setHeader("SOAPAction", "http://schemas.microsoft.com/sharepoint/soap/CheckOutFile");
            soapPost.setHeader("User-Agent", "Microsoft Office/12.0 (Windows NT 5.1; Microsoft Office Word 12.0.4518; Pro)");
            soapPost.setHeader("X-Office-Version", "12.0.4518");
            serviceResponse = this.httpClient.execute((HttpUriRequest)soapPost);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() != 200) {
            throw new ServiceResponseException("Invalid response to FPSE request. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(serviceEndpoint));
        }
        HttpEntity responseEntity = serviceResponse.getEntity();
        if (responseEntity == null) {
            throw new ServiceResponseException("FPSE request does not return a Entity.");
        }
        Document xmlResponse = null;
        try (InputStream in = responseEntity.getContent();){
            try {
                xmlResponse = this.getDocumentFromStream(in);
            }
            catch (DocumentException e) {
                throw new ServiceResponseException("Error reading soap response.");
            }
        }
        catch (IOException ioe) {
            throw new ServiceCommunicationException(ioe);
        }
        Element soapEnvelope = xmlResponse.getRootElement();
        Element soapBody = soapEnvelope.element("Body");
        Element checkOutFileResponse = soapBody.element("CheckOutFileResponse");
        Element checkOutFileResult = checkOutFileResponse.element("CheckOutFileResult");
        String result = checkOutFileResult.getText();
        return result.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean soapCheckin(URI serviceEndpoint, URI target, String comment) throws ServiceCommunicationException, ServiceResponseException {
        CloseableHttpResponse serviceResponse;
        URI listsUri;
        try {
            listsUri = URIUtils.createURI((String)serviceEndpoint.getScheme(), (String)serviceEndpoint.getHost(), (int)serviceEndpoint.getPort(), (String)(serviceEndpoint.getPath() + "/_vti_bin/lists.asmx"), null, null);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        StringBuilder soapRequest = new StringBuilder();
        soapRequest.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        soapRequest.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        soapRequest.append("<soap:Body>");
        soapRequest.append("<CheckInFile xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        soapRequest.append("<pageUrl>");
        soapRequest.append(target.toString());
        soapRequest.append("</pageUrl>");
        soapRequest.append("<comment>");
        soapRequest.append(comment);
        soapRequest.append("</comment>");
        soapRequest.append("<CheckinType>0</CheckinType>");
        soapRequest.append("</CheckInFile>");
        soapRequest.append("</soap:Body>");
        soapRequest.append("</soap:Envelope>");
        try {
            HttpPost soapPost = new HttpPost(listsUri);
            soapPost.setEntity((HttpEntity)new StringEntity(soapRequest.toString(), "text/xml", "UTF-8"));
            soapPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            soapPost.setHeader("SOAPAction", "http://schemas.microsoft.com/sharepoint/soap/CheckInFile");
            soapPost.setHeader("User-Agent", "Microsoft Office/12.0 (Windows NT 5.1; Microsoft Office Word 12.0.4518; Pro)");
            soapPost.setHeader("X-Office-Version", "12.0.4518");
            serviceResponse = this.httpClient.execute((HttpUriRequest)soapPost);
        }
        catch (Exception e) {
            throw new ServiceCommunicationException(e);
        }
        this.checkForRequiredHeaders((HttpResponse)serviceResponse, true);
        if (serviceResponse.getStatusLine().getStatusCode() != 200) {
            throw new ServiceResponseException("Invalid response to FPSE request. StatusCode=" + serviceResponse.getStatusLine().getStatusCode() + " ReasonPhrase=" + serviceResponse.getStatusLine().getReasonPhrase() + " URI=" + String.valueOf(serviceEndpoint));
        }
        HttpEntity responseEntity = serviceResponse.getEntity();
        if (responseEntity == null) {
            throw new ServiceResponseException("FPSE request does not return a Entity.");
        }
        Document xmlResponse = null;
        try (InputStream in = responseEntity.getContent();){
            try {
                xmlResponse = this.getDocumentFromStream(in);
            }
            catch (DocumentException e) {
                throw new ServiceResponseException("Error reading soap response.");
            }
        }
        catch (IOException ioe) {
            throw new ServiceCommunicationException(ioe);
        }
        Element soapEnvelope = xmlResponse.getRootElement();
        Element soapBody = soapEnvelope.element("Body");
        Element checkInFileResponse = soapBody.element("CheckInFileResponse");
        Element checkInFileResult = checkInFileResponse.element("CheckInFileResult");
        String result = checkInFileResult.getText();
        return result.equalsIgnoreCase("true");
    }

    protected FPSEResponseElement getMandatoryElement(FPSEResponseElement elem, String name) throws ServiceResponseException {
        FPSEResponseElement result = elem.getSubElement(name);
        if (result == null) {
            throw new ServiceResponseException("sub element '" + name + "' missing");
        }
        return result;
    }

    protected void checkForRequiredHeaders(HttpResponse serviceResponse, boolean strict) throws ServiceResponseException {
        String msows;
        String mspts = AoservicesClient.getHeaderValue(serviceResponse, "MicrosoftSharePointTeamServices", strict);
        if (!(mspts.startsWith("6.0.2.") || mspts.startsWith("12.0.0.") || mspts.startsWith("14.0.0.") || mspts.startsWith("15.0.0."))) {
            throw new ServiceResponseException("Invalid/Unexpected value for HTTP header MicrosoftSharePointTeamServices: " + mspts);
        }
        String msav = AoservicesClient.getHeaderValue(serviceResponse, "MS-Author-Via", strict);
        if (!msav.equals("MS-FP/4.0,DAV")) {
            if (strict) {
                throw new ServiceResponseException("Invalid/Unexpected value for HTTP header MS-Author-Via");
            }
            this.emitMessage("WARNING: Invalid/Unexpected value for HTTP header MS-Author-Via");
        }
        if (!(msows = AoservicesClient.getHeaderValue(serviceResponse, "MicrosoftOfficeWebServer", strict)).equals("5.0_Collab")) {
            if (strict) {
                throw new ServiceResponseException("Invalid/Unexpected value for HTTP header MicrosoftOfficeWebServer");
            }
            this.emitMessage("WARNING: Invalid/Unexpected value for HTTP header MicrosoftOfficeWebServer");
        }
        AoservicesClient.getHeaderValue(serviceResponse, "DocumentManagementServer", strict);
        String dav = AoservicesClient.getHeaderValue(serviceResponse, "DAV", strict);
        if (!dav.equals("1,2")) {
            if (strict) {
                throw new ServiceResponseException("Invalid/Unexpected value for HTTP header DAV");
            }
            this.emitMessage("WARNING: Invalid/Unexpected value for HTTP header DAV");
        }
    }

    protected static String getHeaderValue(HttpResponse serviceResponse, String headerName, boolean strict) throws ServiceResponseException {
        Header hdr = serviceResponse.getLastHeader(headerName);
        if (hdr == null || hdr.getValue() == null) {
            if (strict) {
                throw new ServiceResponseException("Required header is missing: " + headerName);
            }
            return "";
        }
        return hdr.getValue();
    }

    protected static boolean arrayCompare(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    protected static byte[] streamToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = -1;
        while ((read = in.read(buffer)) >= 0) {
            bos.write(buffer, 0, read);
        }
        return bos.toByteArray();
    }

    public static byte[] getResourceAsByteArray(String resource) {
        byte[] byArray;
        InputStream in = AoservicesClient.getResourceAsStream(resource);
        try {
            byArray = AoservicesClient.streamToByteArray(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error reading resource", ioe);
            }
        }
        in.close();
        return byArray;
    }

    public static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = AoservicesClient.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = AoservicesClient.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException("Can not read resource " + resource);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocumentFromStream(InputStream is) throws IOException, DocumentException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return DocumentHelper.parseText((String)((Object)writer).toString());
    }

    static {
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }

    public static enum VTI_INF_VERSION {
        VER6,
        VER12,
        VER14,
        VER15;

    }

    public static enum OptionsHeaderValidation {
        NONE,
        IMPORTANT,
        ALL;

    }

    public class FPSEVersion {
        public int major;
        public int minor;
        public int phase;
        public int increase;
    }

    public class FPSEUrlToWebUrl {
        public String webUrl;
        public String fileUrl;
        public URI fpseEndpoint;
    }

    public class FPSEGetDocsMetaInfo {
        public Map<String, FPSEResponseElement> urldirs = new HashMap<String, FPSEResponseElement>();
        public Map<String, FileStatus> document_list = new HashMap<String, FileStatus>();
    }

    public class FileStatus {
        LockState lockState;
        String lockUser;
        FPSEResponseElement metaInfo;

        public String toString() {
            switch (this.lockState) {
                case NONE: {
                    return "not-locked";
                }
                case LOCKED: {
                    return "short-term-locked by " + this.lockUser;
                }
                case CHECKEDOUT: {
                    return "checked-out by " + this.lockUser;
                }
            }
            return "--error--";
        }
    }

    public static enum LockState {
        NONE,
        LOCKED,
        CHECKEDOUT;

    }

    public static enum DialogType {
        FileOpen,
        FileSave,
        SaveForm;

    }
}

