/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.entity.AbstractHttpEntity;

public class FPSERequestEntity extends AbstractHttpEntity implements Cloneable
{
    
    protected final byte[] content;
    
    public FPSERequestEntity(byte[] data)
    {
        content = data;
        setContentType("application/x-www-form-urlencoded");
    }

    public boolean isRepeatable()
    {
        return true;
    }

    public long getContentLength()
    {
        return content.length;
    }

    public InputStream getContent() throws IOException, IllegalStateException
    {
        return new ByteArrayInputStream(content);
    }

    public void writeTo(OutputStream outstream) throws IOException
    {
        if (outstream == null)
        {
            throw new NullPointerException("Output stream must not be null");
        }
        outstream.write(content);
        outstream.flush();
    }

    public boolean isStreaming()
    {
        return false;
    }

    public Object clone() throws CloneNotSupportedException
    {
        return super.clone();
    }

}
