/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.office;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.officeservices.testclient.AoserviceClientMessageReceiver;
import org.alfresco.officeservices.testclient.AoservicesClient;
import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.alfresco.officeservices.testclient.office.OfficeClientMessageReceiver;
import org.alfresco.officeservices.testclient.office.OfficeFileHandle;
import org.alfresco.officeservices.testclient.util.URLEncoder;
import org.alfresco.officeservices.testclient.util.URLPathDecoder;
import org.apache.http.client.utils.URIUtils;

public abstract class AbstractOfficeClient
implements AoserviceClientMessageReceiver {
    protected static URLEncoder urlEncoder = new URLEncoder();
    protected AoservicesClient servicesClient = null;
    protected OfficeClientMessageReceiver messageReceiver = null;
    protected List<String> vtiInfHosts = new ArrayList<String>();
    protected List<String> fpseVersionHosts = new ArrayList<String>();
    protected Map<String, String> fpseOpenedHosts = new HashMap<String, String>();

    public AbstractOfficeClient(String username, String password) {
        this.servicesClient = new AoservicesClient(username, password);
        this.servicesClient.setMessageReceiver(this);
    }

    public void setMessageReceiver(OfficeClientMessageReceiver receiver) {
        this.messageReceiver = receiver;
    }

    protected void emitMessage(String msg) {
        if (this.messageReceiver != null) {
            this.messageReceiver.message(msg);
        }
    }

    @Override
    public void message(String msg) {
        this.emitMessage("    " + msg);
    }

    protected String buildHostString(URI target) throws ServiceCommunicationException {
        try {
            return URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new ServiceCommunicationException(e);
        }
    }

    protected void ensureVtiInf(URI target) throws ServiceCommunicationException, ServiceResponseException {
        if (this.vtiInfHosts.contains(this.buildHostString(target))) {
            return;
        }
        this.vtiInfHosts.add(this.buildHostString(target));
        this.emitMessage("Getting _vti_inf.html...");
        AoservicesClient.VTI_INF_VERSION viv = this.servicesClient.getVtiInformation(target);
        this.emitMessage("Service information file is of version " + String.valueOf((Object)viv));
    }

    protected void ensureFpseVersion(URI target) throws ServiceCommunicationException, ServiceResponseException {
        if (this.fpseVersionHosts.contains(this.buildHostString(target))) {
            return;
        }
        this.fpseVersionHosts.add(this.buildHostString(target));
        this.emitMessage("Getting FPSE version...");
        AoservicesClient.FPSEVersion fpseVersion = this.servicesClient.getFPSEVersion(target);
        this.emitMessage("FPSE version major=" + fpseVersion.major + " minor=" + fpseVersion.minor + " phase=" + fpseVersion.phase + " incr=" + fpseVersion.increase);
    }

    public AbstractOfficeClient() {
    }

    protected String ensureOpenService(URI target) throws ServiceCommunicationException, ServiceResponseException {
        String cachedUsername = this.fpseOpenedHosts.get(target.toString());
        if (cachedUsername != null) {
            return cachedUsername;
        }
        this.emitMessage("Opening FPSE service...");
        FPSEResponseElement openServiceElement = this.servicesClient.getFPSEOpenService(target);
        String username = openServiceElement.getSubElement("vti_username").getValue();
        if (!username.startsWith("SX|")) {
            throw new ServiceResponseException("invalid username format");
        }
        username = username.substring(3);
        username = username.replace("&#92;", "\\");
        this.emitMessage("openen service for user " + username);
        this.fpseOpenedHosts.put(target.toString(), username);
        return username;
    }

    public String urlDecodePath(String in) {
        try {
            return URLPathDecoder.decode(in, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Missing UTF8 support", uee);
        }
    }

    public abstract void fileOpenDialog(URI var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract void fileSaveDialog(URI var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract OfficeFileHandle openFile(URI var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract void refreshLock(OfficeFileHandle var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract void closeFile(OfficeFileHandle var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract void checkoutFile(OfficeFileHandle var1) throws ServiceCommunicationException, ServiceResponseException;

    public abstract void checkinFile(OfficeFileHandle var1, String var2, boolean var3) throws ServiceCommunicationException, ServiceResponseException;

    static {
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

