/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.office;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.alfresco.officeservices.testclient.AoservicesClient;
import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.alfresco.officeservices.testclient.office.AbstractOfficeClient;
import org.alfresco.officeservices.testclient.office.OfficeFileHandle;
import org.apache.http.client.utils.URIUtils;

public class Office2007WindowsXPClient
extends AbstractOfficeClient {
    public Office2007WindowsXPClient(String username, String password) {
        super(username, password);
    }

    @Override
    public void fileOpenDialog(URI target) throws ServiceCommunicationException, ServiceResponseException {
        this.fileDialog(target, AoservicesClient.DialogType.FileOpen);
    }

    @Override
    public void fileSaveDialog(URI target) throws ServiceCommunicationException, ServiceResponseException {
        this.fileDialog(target, AoservicesClient.DialogType.FileSave);
    }

    public void fileDialog(URI target, AoservicesClient.DialogType dialogType) throws ServiceCommunicationException, ServiceResponseException {
        AoservicesClient.FPSEUrlToWebUrl fpseUrlToWebUrl;
        block11: {
            boolean repeated = false;
            fpseUrlToWebUrl = null;
            while (true) {
                this.emitMessage("Getting server options...");
                try {
                    if (!this.servicesClient.options(URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), null, null, null), AoservicesClient.OptionsHeaderValidation.NONE)) {
                        throw new ServiceResponseException("OPTIONS request for server root failed");
                    }
                }
                catch (URISyntaxException use) {
                    throw new ServiceResponseException(use);
                }
                this.emitMessage("Server valid.");
                this.emitMessage("Getting target options...");
                if (!this.servicesClient.options(target, AoservicesClient.OptionsHeaderValidation.NONE)) {
                    throw new ServiceResponseException("OPTIONS request for target failed");
                }
                this.emitMessage("valid.");
                this.ensureVtiInf(target);
                this.ensureFpseVersion(target);
                this.emitMessage("Getting fileUrl and webUrl...");
                fpseUrlToWebUrl = this.servicesClient.getFPSEUrlToWebUrl(target);
                this.emitMessage("webUrl=" + fpseUrlToWebUrl.webUrl + " fileUrl=" + fpseUrlToWebUrl.fileUrl);
                this.ensureOpenService(fpseUrlToWebUrl.fpseEndpoint);
                if (fpseUrlToWebUrl.fileUrl.length() <= 0) break block11;
                this.emitMessage("Getting FPSE status of " + fpseUrlToWebUrl.fileUrl + "...");
                ArrayList<String> targets = new ArrayList<String>(1);
                targets.add(fpseUrlToWebUrl.fileUrl);
                AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(fpseUrlToWebUrl.fpseEndpoint, targets);
                FPSEResponseElement metaInfo = docsMetaInfo.urldirs.get(fpseUrlToWebUrl.fileUrl);
                if (metaInfo != null) break;
                this.emitMessage("Target invalid.");
                if (repeated) {
                    fpseUrlToWebUrl.fileUrl = "";
                    continue;
                }
                int pos = target.getPath().lastIndexOf(47);
                if (pos == -1) {
                    fpseUrlToWebUrl.fileUrl = "";
                    continue;
                }
                try {
                    target = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)target.getPath().substring(0, pos - 1), null, null);
                }
                catch (URISyntaxException use) {
                    throw new ServiceResponseException(use);
                }
                repeated = true;
            }
            this.emitMessage("Target is valid.");
        }
        this.emitMessage("Testing Web Form existance...");
        boolean webFormExists = this.servicesClient.testWebFormExistence(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, AoservicesClient.DialogType.FileOpen);
        if (!webFormExists) {
            throw new ServiceResponseException("Web form for target does not exist. target:" + String.valueOf(target));
        }
        this.emitMessage("Web form exists.");
        this.emitMessage("Getting Web Form...");
        boolean webFormDelivered = this.servicesClient.getWebForm(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, dialogType, null);
        if (!webFormDelivered) {
            throw new ServiceResponseException("Web form not received. target:" + String.valueOf(target));
        }
        this.emitMessage("Web form received.");
    }

    @Override
    public OfficeFileHandle openFile(URI target) throws ServiceCommunicationException, ServiceResponseException {
        FPSEResponseElement LibraryDescription;
        int pos;
        this.emitMessage("Getting target options...");
        if (!this.servicesClient.options(target, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for target failed");
        }
        this.emitMessage("valid.");
        this.ensureVtiInf(target);
        this.ensureFpseVersion(target);
        this.emitMessage("Getting fileUrl and webUrl...");
        AoservicesClient.FPSEUrlToWebUrl fpseUrlToWebUrl = this.servicesClient.getFPSEUrlToWebUrl(target);
        this.emitMessage("webUrl=" + fpseUrlToWebUrl.webUrl + " fileUrl=" + fpseUrlToWebUrl.fileUrl);
        String username = this.ensureOpenService(fpseUrlToWebUrl.fpseEndpoint);
        this.emitMessage("Getting FPSE status of " + target.toString() + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(this.urlDecodePath(target.toString()));
        String x = target.getPath();
        String libraryPath = null;
        if (x.startsWith(fpseUrlToWebUrl.webUrl + "/") && (pos = (x = x.substring(fpseUrlToWebUrl.webUrl.length() + 1)).indexOf(47)) > 0) {
            try {
                libraryPath = fpseUrlToWebUrl.webUrl.substring(1) + "/" + x.substring(0, pos);
                URI docLibUri = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)("/" + libraryPath), null, null);
                targets.add(this.urlDecodePath(docLibUri.toString()));
                this.emitMessage("...and FPSE status of " + docLibUri.toString() + "...");
            }
            catch (URISyntaxException use) {
                throw new ServiceResponseException(use);
            }
        }
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(fpseUrlToWebUrl.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(fpseUrlToWebUrl.fileUrl);
        this.emitMessage("Received file status " + String.valueOf(status));
        if (libraryPath != null && (LibraryDescription = docsMetaInfo.urldirs.get(libraryPath)) == null) {
            this.emitMessage("WARNING: Library description missing");
        }
        this.emitMessage("Testing HTTP status of target " + target.toString() + "...");
        if (!this.servicesClient.doHead(target)) {
            throw new ServiceResponseException("HEAD request for target failed");
        }
        this.emitMessage("HTTP status valid");
        this.emitMessage("Checkout document...");
        AoservicesClient.FileStatus checkoutStatus = this.servicesClient.getFPSECheckoutDocument(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, 10);
        this.emitMessage("Received document status: " + String.valueOf(checkoutStatus));
        this.emitMessage("Getting FPSE status of " + fpseUrlToWebUrl.fileUrl + "...");
        targets = new ArrayList(1);
        targets.add(fpseUrlToWebUrl.fileUrl);
        docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(fpseUrlToWebUrl.fpseEndpoint, targets);
        status = docsMetaInfo.document_list.get(fpseUrlToWebUrl.fileUrl);
        this.emitMessage("Received status " + String.valueOf(status));
        this.emitMessage("Uncheckout document...");
        status = this.servicesClient.getFPSEUncheckoutDocument(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, true);
        this.emitMessage("Received document status: " + String.valueOf(status));
        this.emitMessage("Getting document...");
        AoservicesClient.FileStatus documentStatus = this.servicesClient.getFPSEGetDocument(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl);
        this.emitMessage("Received document status: " + String.valueOf(documentStatus));
        this.emitMessage("Testing HTTP status of target " + target.toString() + "...");
        if (!this.servicesClient.doHead(target)) {
            throw new ServiceResponseException("HEAD request for target failed");
        }
        this.emitMessage("HTTP status valid");
        OfficeFileHandle ofh = new OfficeFileHandle();
        ofh.target = target;
        ofh.fileUrl = fpseUrlToWebUrl.fileUrl;
        ofh.webUrl = fpseUrlToWebUrl.webUrl;
        ofh.fpseEndpoint = fpseUrlToWebUrl.fpseEndpoint;
        ofh.username = username;
        return ofh;
    }

    @Override
    public void refreshLock(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Checkout document...");
        AoservicesClient.FileStatus status = this.servicesClient.getFPSECheckoutDocument(ofh.fpseEndpoint, ofh.fileUrl, 10);
        this.emitMessage("Received document status: " + String.valueOf(status));
    }

    @Override
    public void closeFile(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Uncheckout document...");
        AoservicesClient.FileStatus status = this.servicesClient.getFPSEUncheckoutDocument(ofh.fpseEndpoint, ofh.fileUrl, true);
        this.emitMessage("Received document status: " + String.valueOf(status));
    }

    @Override
    public void checkoutFile(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Checkout document...");
        if (!this.servicesClient.soapCheckout(ofh.fpseEndpoint, ofh.target, false)) {
            throw new ServiceResponseException("Checkout failed");
        }
        this.emitMessage("Checkout successfull");
        this.emitMessage("Getting FPSE status of " + ofh.fileUrl + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(ofh.fileUrl);
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(ofh.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(ofh.fileUrl);
        this.emitMessage("Received status " + String.valueOf(status));
    }

    @Override
    public void checkinFile(OfficeFileHandle ofh, String comment, boolean keepEditing) throws ServiceCommunicationException, ServiceResponseException {
        FPSEResponseElement LibraryDescription;
        int pos;
        this.emitMessage("Checkin document...");
        if (!this.servicesClient.soapCheckin(ofh.fpseEndpoint, ofh.target, comment)) {
            throw new ServiceResponseException("Checkin failed");
        }
        this.emitMessage("Checkin successfull");
        if (!keepEditing) {
            this.emitMessage("Uncheckout document...");
            AoservicesClient.FileStatus status = this.servicesClient.getFPSEUncheckoutDocument(ofh.fpseEndpoint, ofh.fileUrl, true);
            this.emitMessage("Received document status: " + String.valueOf(status));
        }
        this.emitMessage("Getting FPSE status of " + ofh.target.toString() + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(this.urlDecodePath(ofh.target.toString()));
        String x = ofh.target.getPath();
        String libraryPath = null;
        if (x.startsWith(ofh.webUrl + "/") && (pos = (x = x.substring(ofh.webUrl.length() + 1)).indexOf(47)) > 0) {
            try {
                libraryPath = ofh.webUrl.substring(1) + "/" + x.substring(0, pos);
                URI docLibUri = URIUtils.createURI((String)ofh.target.getScheme(), (String)ofh.target.getHost(), (int)ofh.target.getPort(), (String)("/" + libraryPath), null, null);
                targets.add(this.urlDecodePath(docLibUri.toString()));
                this.emitMessage("...and FPSE status of " + docLibUri.toString() + "...");
            }
            catch (URISyntaxException use) {
                throw new ServiceResponseException(use);
            }
        }
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(ofh.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(ofh.fileUrl);
        this.emitMessage("Received status " + String.valueOf(status));
        if (libraryPath != null && (LibraryDescription = docsMetaInfo.urldirs.get(libraryPath)) == null) {
            this.emitMessage("WARNING: Library description missing");
        }
    }
}

