/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.office;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.alfresco.officeservices.testclient.AoservicesClient;
import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.alfresco.officeservices.testclient.office.AbstractOfficeClient;
import org.alfresco.officeservices.testclient.office.OfficeFileHandle;
import org.apache.http.client.utils.URIUtils;

public class Office2010Windows7Client
extends AbstractOfficeClient {
    public Office2010Windows7Client(String username, String password) {
        super(username, password);
    }

    @Override
    public void fileOpenDialog(URI target) throws ServiceCommunicationException, ServiceResponseException {
        this.fileDialog(target, AoservicesClient.DialogType.FileOpen);
    }

    @Override
    public void fileSaveDialog(URI target) throws ServiceCommunicationException, ServiceResponseException {
        this.fileDialog(target, AoservicesClient.DialogType.FileSave);
    }

    public void fileDialog(URI target, AoservicesClient.DialogType dialogType) throws ServiceCommunicationException, ServiceResponseException {
        URI serverRoot = null;
        try {
            serverRoot = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), null, null, null);
        }
        catch (URISyntaxException use) {
            throw new ServiceResponseException(use);
        }
        this.emitMessage("Getting target options...");
        if (!this.servicesClient.options(target, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for target failed");
        }
        this.emitMessage("valid.");
        this.emitMessage("Getting target properties...");
        if (!this.servicesClient.propfind(target)) {
            throw new ServiceResponseException("PROPFIND request for target failed");
        }
        this.emitMessage("valid.");
        this.emitMessage("Getting server options...");
        if (!this.servicesClient.options(serverRoot, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for server root failed");
        }
        this.emitMessage("Server valid.");
        this.emitMessage("Getting server properties...");
        if (!this.servicesClient.propfind(serverRoot)) {
            throw new ServiceResponseException("PROPFIND request for target failed");
        }
        this.emitMessage("valid.");
        this.emitMessage("Getting fileUrl and webUrl...");
        AoservicesClient.FPSEUrlToWebUrl fpseUrlToWebUrl = this.servicesClient.getFPSEUrlToWebUrl(target);
        this.emitMessage("webUrl=" + fpseUrlToWebUrl.webUrl + " fileUrl=" + fpseUrlToWebUrl.fileUrl);
        this.emitMessage("Testing Web Form existance...");
        boolean webFormExists = this.servicesClient.testWebFormExistence(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, AoservicesClient.DialogType.FileOpen);
        if (!webFormExists) {
            throw new ServiceResponseException("Web form for target does not exist. target:" + String.valueOf(target));
        }
        this.emitMessage("Web form exists.");
        this.emitMessage("Getting Web Form...");
        boolean webFormDelivered = this.servicesClient.getWebForm(fpseUrlToWebUrl.fpseEndpoint, fpseUrlToWebUrl.fileUrl, dialogType, null);
        if (!webFormDelivered) {
            throw new ServiceResponseException("Web form not received. target:" + String.valueOf(target));
        }
        this.emitMessage("Web form received.");
    }

    @Override
    public OfficeFileHandle openFile(URI target) throws ServiceCommunicationException, ServiceResponseException {
        FPSEResponseElement LibraryDescription;
        int pos;
        URI serverRoot = null;
        try {
            serverRoot = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), null, null, null);
        }
        catch (URISyntaxException use) {
            throw new ServiceResponseException(use);
        }
        this.emitMessage("Getting target options...");
        if (!this.servicesClient.options(target, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for target failed");
        }
        this.emitMessage("valid.");
        this.emitMessage("Getting target properties...");
        if (!this.servicesClient.propfind(target)) {
            throw new ServiceResponseException("PROPFIND request for target failed");
        }
        this.emitMessage("valid.");
        this.emitMessage("Getting server options...");
        if (!this.servicesClient.options(serverRoot, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for server root failed");
        }
        this.emitMessage("Server valid.");
        this.emitMessage("Getting server properties...");
        if (!this.servicesClient.propfind(serverRoot)) {
            throw new ServiceResponseException("PROPFIND request for target failed");
        }
        this.emitMessage("valid.");
        String[] p = urlEncoder.encode(target.getPath()).split("/");
        Object test = "";
        for (String elem : p) {
            boolean emptyPrefix = ((String)test).isEmpty();
            if (!emptyPrefix) {
                test = (String)test + "/";
            }
            test = (String)test + elem;
            if (emptyPrefix && !elem.isEmpty()) {
                test = (String)test + "/";
            }
            try {
                if (this.servicesClient.propfind(URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)test, null, null))) continue;
                throw new ServiceResponseException("PROPFIND request for target failed");
            }
            catch (URISyntaxException use) {
                throw new ServiceResponseException(use);
            }
        }
        this.emitMessage("Getting target options...");
        if (!this.servicesClient.options(target, AoservicesClient.OptionsHeaderValidation.ALL)) {
            throw new ServiceResponseException("OPTIONS request for target failed");
        }
        this.emitMessage("valid.");
        this.ensureVtiInf(target);
        this.ensureFpseVersion(target);
        this.emitMessage("Getting fileUrl and webUrl...");
        AoservicesClient.FPSEUrlToWebUrl fpseUrlToWebUrl = this.servicesClient.getFPSEUrlToWebUrl(target);
        this.emitMessage("webUrl=" + fpseUrlToWebUrl.webUrl + " fileUrl=" + fpseUrlToWebUrl.fileUrl);
        String username = this.ensureOpenService(fpseUrlToWebUrl.fpseEndpoint);
        this.emitMessage("Getting FPSE status of " + target.toString() + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(this.urlDecodePath(target.toString()));
        String x = target.getPath();
        String libraryPath = null;
        if (x.startsWith(fpseUrlToWebUrl.webUrl + "/") && (pos = (x = x.substring(fpseUrlToWebUrl.webUrl.length() + 1)).indexOf(47)) > 0) {
            try {
                libraryPath = fpseUrlToWebUrl.webUrl.substring(1) + "/" + x.substring(0, pos);
                URI docLibUri = URIUtils.createURI((String)target.getScheme(), (String)target.getHost(), (int)target.getPort(), (String)("/" + libraryPath), null, null);
                targets.add(this.urlDecodePath(docLibUri.toString()));
                this.emitMessage("...and FPSE status of " + docLibUri.toString() + "...");
            }
            catch (URISyntaxException use) {
                throw new ServiceResponseException(use);
            }
        }
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(fpseUrlToWebUrl.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(fpseUrlToWebUrl.fileUrl);
        this.emitMessage("Received file status " + String.valueOf(status));
        if (libraryPath != null && (LibraryDescription = docsMetaInfo.urldirs.get(libraryPath)) == null) {
            this.emitMessage("WARNING: Library description missing");
        }
        this.emitMessage("Locking target...");
        String lockToken = this.servicesClient.lock(target, null);
        if (lockToken == null || lockToken.length() == 0) {
            throw new ServiceResponseException("Invalid lock token");
        }
        this.emitMessage("locked.");
        this.emitMessage("Getting target...");
        if (!this.servicesClient.get(target)) {
            throw new ServiceResponseException("GET request for target failed");
        }
        this.emitMessage("ok.");
        this.emitMessage("Getting target properties...");
        if (!this.servicesClient.propfind(target)) {
            throw new ServiceResponseException("PROPFIND request for target failed");
        }
        this.emitMessage("valid.");
        OfficeFileHandle ofh = new OfficeFileHandle();
        ofh.target = target;
        ofh.fileUrl = fpseUrlToWebUrl.fileUrl;
        ofh.webUrl = fpseUrlToWebUrl.webUrl;
        ofh.fpseEndpoint = fpseUrlToWebUrl.fpseEndpoint;
        ofh.username = username;
        ofh.webdavLockToken = lockToken;
        return ofh;
    }

    @Override
    public void refreshLock(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Re-Locking target...");
        String lockToken = this.servicesClient.lock(ofh.target, ofh.webdavLockToken);
        if (lockToken == null || lockToken.length() == 0) {
            throw new ServiceResponseException("Invalid lock token");
        }
        ofh.webdavLockToken = lockToken;
        this.emitMessage("re-locked.");
    }

    @Override
    public void closeFile(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Unlocking target...");
        this.servicesClient.unlock(ofh.target, ofh.webdavLockToken);
        this.emitMessage("unlocked.");
    }

    @Override
    public void checkoutFile(OfficeFileHandle ofh) throws ServiceCommunicationException, ServiceResponseException {
        this.emitMessage("Checkout document...");
        if (!this.servicesClient.soapCheckout(ofh.fpseEndpoint, ofh.target, false)) {
            throw new ServiceResponseException("Checkout failed");
        }
        this.emitMessage("Checkout successfull");
        this.emitMessage("Getting FPSE status of " + ofh.fileUrl + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(ofh.fileUrl);
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(ofh.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(ofh.fileUrl);
        this.emitMessage("Received status " + String.valueOf(status));
    }

    @Override
    public void checkinFile(OfficeFileHandle ofh, String comment, boolean keepEditing) throws ServiceCommunicationException, ServiceResponseException {
        FPSEResponseElement LibraryDescription;
        int pos;
        this.emitMessage("Checkin document...");
        if (!this.servicesClient.soapCheckin(ofh.fpseEndpoint, ofh.target, comment)) {
            throw new ServiceResponseException("Checkin failed");
        }
        this.emitMessage("Checkin successfull");
        if (!keepEditing) {
            this.emitMessage("Uncheckout document...");
            AoservicesClient.FileStatus status = this.servicesClient.getFPSEUncheckoutDocument(ofh.fpseEndpoint, ofh.fileUrl, true);
            this.emitMessage("Received document status: " + String.valueOf(status));
        }
        this.emitMessage("Getting FPSE status of " + ofh.target.toString() + "...");
        ArrayList<String> targets = new ArrayList<String>(1);
        targets.add(this.urlDecodePath(ofh.target.toString()));
        String x = ofh.target.getPath();
        String libraryPath = null;
        if (x.startsWith(ofh.webUrl + "/") && (pos = (x = x.substring(ofh.webUrl.length() + 1)).indexOf(47)) > 0) {
            try {
                libraryPath = ofh.webUrl.substring(1) + "/" + x.substring(0, pos);
                URI docLibUri = URIUtils.createURI((String)ofh.target.getScheme(), (String)ofh.target.getHost(), (int)ofh.target.getPort(), (String)("/" + libraryPath), null, null);
                targets.add(this.urlDecodePath(docLibUri.toString()));
                this.emitMessage("...and FPSE status of " + docLibUri.toString() + "...");
            }
            catch (URISyntaxException use) {
                throw new ServiceResponseException(use);
            }
        }
        AoservicesClient.FPSEGetDocsMetaInfo docsMetaInfo = this.servicesClient.getFPSEGetDocsMetaInfo(ofh.fpseEndpoint, targets);
        AoservicesClient.FileStatus status = docsMetaInfo.document_list.get(ofh.fileUrl);
        this.emitMessage("Received status " + String.valueOf(status));
        if (libraryPath != null && (LibraryDescription = docsMetaInfo.urldirs.get(libraryPath)) == null) {
            this.emitMessage("WARNING: Library description missing");
        }
    }
}

