/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class CustomAuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private OAuth2AuthorizationRequestResolver defaultResolver;
    private AIMSConfig aimsConfig;
    private static final String AUDIENCE = "audience";

    public CustomAuthorizationRequestResolver(ClientRegistrationRepository repo, String authorizationRequestBaseUri, AIMSConfig aimsConfig) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(repo, authorizationRequestBaseUri);
        this.aimsConfig = aimsConfig;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest httpServletRequest) {
        OAuth2AuthorizationRequest oAuth2AuthorizationRequest = this.defaultResolver.resolve(httpServletRequest);
        if (oAuth2AuthorizationRequest != null) {
            oAuth2AuthorizationRequest = this.customizeAuthorizationRequest(oAuth2AuthorizationRequest, httpServletRequest);
        }
        return oAuth2AuthorizationRequest;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest httpServletRequest, String clientRegistrationId) {
        OAuth2AuthorizationRequest oAuth2AuthorizationRequest = this.defaultResolver.resolve(httpServletRequest, clientRegistrationId);
        if (oAuth2AuthorizationRequest != null) {
            oAuth2AuthorizationRequest = this.customizeAuthorizationRequest(oAuth2AuthorizationRequest, httpServletRequest);
        }
        return oAuth2AuthorizationRequest;
    }

    private OAuth2AuthorizationRequest customizeAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request) {
        String requestURI;
        HashMap<String, String> extraParams = new HashMap<String, String>();
        String string = requestURI = this.aimsConfig.getRedirectURI() != null ? this.aimsConfig.getRedirectURI() : String.valueOf(request.getRequestURL());
        if (this.aimsConfig.getAudience() != null) {
            extraParams.put(AUDIENCE, this.aimsConfig.getAudience());
            return ((OAuth2AuthorizationRequest.Builder)((OAuth2AuthorizationRequest.Builder)OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)authorizationRequest).redirectUri(requestURI)).additionalParameters(extraParams)).build();
        }
        return ((OAuth2AuthorizationRequest.Builder)OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)authorizationRequest).redirectUri(requestURI)).build();
    }
}

