/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

class DefaultControlsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_DEFAULT_CONTROLS = "default-controls";
    public static final String ELEMENT_CONTROL_PARAM = "control-param";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TEMPLATE = "template";

    DefaultControlsElementReader() {
    }

    public ConfigElement parse(Element defaultCtrlsElem) {
        DefaultControlsConfigElement result = null;
        if (defaultCtrlsElem == null) {
            return null;
        }
        String name = defaultCtrlsElem.getName();
        if (!name.equals(ELEMENT_DEFAULT_CONTROLS)) {
            throw new ConfigException(this.getClass().getName() + " can only parse default-controls elements, the element passed was '" + name + "'");
        }
        result = new DefaultControlsConfigElement();
        Iterator typeNodes = defaultCtrlsElem.elementIterator();
        while (typeNodes.hasNext()) {
            Element nextTypeNode = (Element)typeNodes.next();
            String typeName = nextTypeNode.attributeValue(ATTR_NAME);
            String templatePath = nextTypeNode.attributeValue(ATTR_TEMPLATE);
            List controlParamNodes = nextTypeNode.elements(ELEMENT_CONTROL_PARAM);
            ControlParam param = null;
            ArrayList<ControlParam> params = new ArrayList<ControlParam>();
            for (Element nextControlParam : controlParamNodes) {
                String paramName = nextControlParam.attributeValue(ATTR_NAME);
                String elementValue = nextControlParam.getTextTrim();
                param = new ControlParam(paramName, elementValue);
                params.add(param);
            }
            result.addDataMapping(typeName, templatePath, params);
        }
        return result;
    }
}

