/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.mvc.FeedController;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class SlingshotFeedController
extends FeedController {
    public static final String ENDPOINT_ALFRESCO_FEED = "alfresco-feed";
    private RemoteConfigElement config;
    private ConfigService configService;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) {
        RemoteConfigElement.EndpointDescriptor descriptor = this.getRemoteConfig().getEndpointDescriptor(ENDPOINT_ALFRESCO_FEED);
        if (!descriptor.getExternalAuth()) {
            return super.handleRequestInternal(req, res);
        }
        Object uri = (String)req.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        uri = (String)uri + (String)(req.getQueryString() != null ? "?" + req.getQueryString() : "");
        try {
            req.getRequestDispatcher("/page/" + (String)uri).forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException(e.getMessage(), e);
        }
        return null;
    }

    private RemoteConfigElement getRemoteConfig() {
        if (this.config == null) {
            this.config = (RemoteConfigElement)this.configService.getConfig((Object)"Remote").getConfigElement("remote");
        }
        return this.config;
    }
}

