/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.event.outbox;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import org.alfresco.event.outbox.EventTable;
import org.alfresco.event.outbox.InternalEvent;

class OracleEventTable
extends EventTable {
    private final String createTableSql = "CREATE TABLE %s(%s NUMBER GENERATED ALWAYS as IDENTITY(START with 1 INCREMENT by 1) PRIMARY KEY, %s TIMESTAMP WITH TIME ZONE NOT NULL, %s CLOB NOT NULL )".formatted(this.getTableName(), this.getIdColumnName(), this.getReceivedAtColumnName(), this.getEventDataColumnName());
    private final String insertEventSql = "INSERT INTO %s(%s, %s) VALUES(?, ?)".formatted(this.getTableName(), this.getReceivedAtColumnName(), this.getEventDataColumnName());
    private final String fetchEventsSql = "SELECT %s, %s, %s FROM %s WHERE %s IN (SELECT %s FROM %s ORDER BY %s FETCH FIRST ? ROWS ONLY)   ORDER BY %s FOR UPDATE".formatted(this.getIdColumnName(), this.getReceivedAtColumnName(), this.getEventDataColumnName(), this.getTableName(), this.getIdColumnName(), this.getIdColumnName(), this.getTableName(), this.getIdColumnName(), this.getIdColumnName());
    private final String deleteEventsSql = "DELETE FROM %s WHERE %s IN (:eventIds)".formatted(this.getTableName(), this.getIdColumnName());
    private final String statsSql = "SELECT count(%s), min(%s) FROM %s".formatted(this.getIdColumnName(), this.getReceivedAtColumnName(), this.getTableName());
    private static final int MAX_PARAMETERS = 1000;

    OracleEventTable() {
    }

    @Override
    public long deleteEvents(Connection connection, List<Long> ids) throws SQLException {
        return this.divideIntoBatchesAndExecute(ids, 1000, batch -> super.deleteEvents(connection, (List<Long>)batch));
    }

    @Override
    protected EventTable.SqlStatement getCreateTableStatement() {
        return EventTable.SqlStatement.create(this.createTableSql, new EventTable.SqlStatement.StatementPreparer[0]);
    }

    @Override
    protected EventTable.SqlStatement getInsertEventStatement(InternalEvent event) {
        return EventTable.SqlStatement.create(this.insertEventSql, s -> s.setTimestamp(1, Timestamp.from(event.receivedTime())), s -> s.setString(2, event.eventData()));
    }

    @Override
    protected EventTable.SqlStatement getFetchEventsStatement(int fetchLimit) {
        return EventTable.SqlStatement.create(this.fetchEventsSql, s -> s.setInt(1, fetchLimit));
    }

    @Override
    protected EventTable.SqlStatement getDeleteEventsStatement(Connection connection, List<Long> ids) {
        return this.prepareStatementForMultipleParams(ids, this.deleteEventsSql, ":eventIds");
    }

    @Override
    protected EventTable.SqlStatement getStatsStatement() {
        return EventTable.SqlStatement.create(this.statsSql, new EventTable.SqlStatement.StatementPreparer[0]);
    }

    @Override
    protected String getTableName() {
        return super.getTableName().toUpperCase(Locale.ROOT);
    }
}

