/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.ClusterMessageAware;
import org.springframework.extensions.surf.ClusterService;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class ClusterTopicService
implements MessageListener<String>,
ClusterService,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ClusterTopicService.class);
    private HazelcastInstance hazelcastInstance;
    private String hazelcastTopicName;
    private ITopic<String> clusterTopic = null;
    private Map<String, ClusterMessageAware> clusterBeans = null;
    private static final String clusterNodeId = GUID.generate();
    private ApplicationContext applicationContext = null;

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void setHazelcastTopicName(String hazelcastTopicName) {
        this.hazelcastTopicName = hazelcastTopicName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        if (this.hazelcastInstance == null) {
            throw new IllegalArgumentException("The 'hazelcastInstance' property (HazelcastInstance) is mandatory.");
        }
        if (this.hazelcastTopicName == null || this.hazelcastTopicName.length() == 0) {
            throw new IllegalArgumentException("The 'hazelcastTopicName' property (String) is mandatory.");
        }
        ITopic topic = this.hazelcastInstance.getTopic(this.hazelcastTopicName);
        if (topic == null) {
            throw new IllegalArgumentException("Did not find Hazelcast topic with name: '" + this.hazelcastTopicName + "' - cannot init.");
        }
        Map beans = this.applicationContext.getBeansOfType(ClusterMessageAware.class);
        this.clusterBeans = new HashMap<String, ClusterMessageAware>();
        for (String id : beans.keySet()) {
            ClusterMessageAware bean = (ClusterMessageAware)beans.get(id);
            String messageType = bean.getClusterMessageType();
            if (messageType != null) {
                if (this.clusterBeans.containsKey(messageType)) {
                    throw new IllegalStateException("ClusterMessageAware bean with id '" + id + "' attempted to register with existing Message Type: " + messageType);
                }
                this.clusterBeans.put(messageType, bean);
            }
            bean.setClusterService((ClusterService)this);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registered beans for cluster messages:");
            for (String id : beans.keySet()) {
                logger.debug((Object)(id + " [" + ((ClusterMessageAware)beans.get(id)).getClusterMessageType() + "]"));
            }
        }
        this.clusterTopic = topic;
        this.clusterTopic.addMessageListener((MessageListener)this);
        logger.info((Object)("Init complete for Hazelcast cluster - listening on topic: " + this.hazelcastTopicName));
    }

    public void publishClusterMessage(String messageType, Map<String, Serializable> payload) {
        ClusterMessageImpl msg = new ClusterMessageImpl(messageType, payload);
        String serialised = ((Object)msg).toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Pushing message:\r\n" + serialised));
        }
        this.clusterTopic.publish((Object)serialised);
    }

    public void onMessage(Message<String> message) {
        boolean debug = logger.isDebugEnabled();
        String msg = (String)message.getMessageObject();
        MessageProcessor proc = new MessageProcessor(msg);
        if (!proc.isSender()) {
            ClusterMessageAware bean;
            if (debug) {
                logger.debug((Object)("Received message of type:" + proc.getMessageType() + "\r\n" + msg));
            }
            if ((bean = this.clusterBeans.get(proc.getMessageType())) != null) {
                bean.onClusterMessage(proc.getMessagePayload());
            } else {
                logger.warn((Object)("Received message of unknown type - no handler bean found: " + proc.getMessageType()));
            }
        }
    }

    static class ClusterMessageImpl
    implements ClusterMessage {
        private final String type;
        final Map<String, Serializable> payload;

        ClusterMessageImpl(String type, Map<String, Serializable> payload) {
            this.type = type;
            this.payload = payload;
        }

        @Override
        public Map<String, Serializable> getPayload() {
            return this.payload;
        }

        @Override
        public String getSender() {
            return clusterNodeId;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            try {
                StringBuilderWriter buffer = new StringBuilderWriter(512);
                JSONWriter writer = new JSONWriter((Writer)buffer);
                writer.startObject();
                writer.writeValue("sender", this.getSender());
                writer.startValue("message");
                writer.startObject();
                writer.writeValue("type", this.getType());
                writer.startValue("payload");
                ClusterMessageImpl.serialiseMessageObjects(writer, null, (Serializable)((Object)this.payload));
                writer.endValue();
                writer.endObject();
                writer.endValue();
                writer.endObject();
                return buffer.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialise cluster message: " + e.getMessage(), e);
            }
        }

        static void serialiseMessageObjects(JSONWriter writer, String name, Serializable obj) throws IOException {
            if (obj instanceof Map) {
                if (name != null) {
                    writer.startValue(name);
                }
                writer.startObject();
                Map map = (Map)((Object)obj);
                for (String key : map.keySet()) {
                    ClusterMessageImpl.serialiseMessageObjects(writer, key, (Serializable)map.get(key));
                }
                writer.endObject();
                if (name != null) {
                    writer.endValue();
                }
            } else if (obj instanceof List) {
                if (name != null) {
                    writer.startValue(name);
                }
                writer.startArray();
                for (Object item : (List)((Object)obj)) {
                    ClusterMessageImpl.serialiseMessageObjects(writer, null, (Serializable)item);
                }
                writer.endArray();
                if (name != null) {
                    writer.endValue();
                }
            } else if (obj instanceof Integer) {
                if (name != null) {
                    writer.writeValue(name, ((Integer)obj).intValue());
                } else {
                    writer.writeValue(((Integer)obj).intValue());
                }
            } else if (obj instanceof Boolean) {
                if (name != null) {
                    writer.writeValue(name, ((Boolean)obj).booleanValue());
                } else {
                    writer.writeValue(((Boolean)obj).booleanValue());
                }
            } else if (obj instanceof Date) {
                if (name != null) {
                    writer.writeValue(name, ISO8601DateFormat.format((Date)((Date)obj)));
                } else {
                    writer.writeValue(ISO8601DateFormat.format((Date)((Date)obj)));
                }
            } else if (obj == null) {
                if (name != null) {
                    writer.writeNullValue(name);
                } else {
                    writer.writeNullValue();
                }
            } else if (name != null) {
                writer.writeValue(name, obj.toString());
            } else {
                writer.writeValue(obj.toString());
            }
        }
    }

    static class MessageProcessor {
        private final String sender;
        private final String type;
        private final Map<String, Serializable> payload;

        MessageProcessor(String msg) {
            try {
                Map json = (Map)new JSONParser().parse(msg, new ContainerFactory(){

                    public Map createObjectContainer() {
                        return new HashMap();
                    }

                    public List creatArrayContainer() {
                        return new ArrayList();
                    }
                });
                this.sender = (String)json.get("sender");
                Map message = (Map)json.get("message");
                this.type = (String)message.get("type");
                this.payload = (Map)message.get("payload");
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to parse cluster JSON message: " + e.getMessage() + "\r\n" + msg);
            }
        }

        boolean isSender() {
            return clusterNodeId.equals(this.sender);
        }

        String getMessageType() {
            return this.type;
        }

        Map<String, Serializable> getMessagePayload() {
            return this.payload;
        }
    }

    static interface ClusterMessage {
        public static final String JSON_SENDER = "sender";
        public static final String JSON_MESSAGE = "message";
        public static final String JSON_TYPE = "type";
        public static final String JSON_PAYLOAD = "payload";

        public String getSender();

        public String getType();

        public Map<String, Serializable> getPayload();
    }
}

