/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.mvc.LoginController;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;

public class SlingshotLoginController
extends LoginController {
    public static String SESSION_ATTRIBUTE_KEY_USER_GROUPS = "_alf_USER_GROUPS";

    protected void onSuccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.beforeSuccess(request, response);
        super.onSuccess(request, response);
    }

    protected void beforeSuccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            String username = request.getParameter("username");
            if (username == null) {
                username = (String)session.getAttribute("_alf_USER_ID");
            }
            if (username != null && session.getAttribute(SESSION_ATTRIBUTE_KEY_USER_GROUPS) == null) {
                Connector conn = FrameworkUtil.getConnector((HttpSession)session, (String)username, (String)"alfresco");
                ConnectorContext c = new ConnectorContext(HttpMethod.GET);
                c.setContentType("application/json");
                Response res = conn.call("/api/people/" + URLEncoder.encode((String)username) + "?groups=true", c);
                if (200 == res.getStatus().getCode()) {
                    Object groupsArray;
                    String resStr = res.getResponse();
                    JSONParser jp = new JSONParser();
                    Object userData = jp.parse(resStr.toString());
                    StringBuilder groups = new StringBuilder(512);
                    if (userData instanceof JSONObject && (groupsArray = ((JSONObject)userData).get((Object)"groups")) instanceof JSONArray) {
                        for (Object groupData : (JSONArray)groupsArray) {
                            Object groupName;
                            if (!(groupData instanceof JSONObject) || (groupName = ((JSONObject)groupData).get((Object)"itemName")) == null) continue;
                            groups.append(groupName.toString()).append(',');
                        }
                    }
                    if (groups.length() != 0) {
                        groups.delete(groups.length() - 1, groups.length());
                    }
                    session.setAttribute(SESSION_ATTRIBUTE_KEY_USER_GROUPS, (Object)groups.toString());
                } else {
                    session.setAttribute(SESSION_ATTRIBUTE_KEY_USER_GROUPS, (Object)"");
                }
            }
        }
        catch (ConnectorServiceException e1) {
            throw new Exception("Error creating remote connector to request user group data.");
        }
    }
}

