/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.config.util.BaseTest;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.junit.Assert;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.xml.XMLConfigService;

public class AIMSConfigTest
extends BaseTest {
    public static final String CLASSPATH_SHARE_CONFIG_PROPERTIES = "classpath*:alfresco/module/*/share-config.properties";
    private static final String TEST_CONFIG_AIMS_BASIC_XML = "test-config-aims-basic.xml";

    private List<String> getConfigFiles() {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add(TEST_CONFIG_AIMS_BASIC_XML);
        return result;
    }

    @Override
    public String getResourcesDir() {
        return "classpath:";
    }

    private void clearSystemProperties() {
        System.clearProperty("aims.enabled");
        System.clearProperty("aims.realm");
        System.clearProperty("aims.resource");
        System.clearProperty("aims.authServerUrl");
        System.clearProperty("aims.sslRequired");
        System.clearProperty("aims.publicClient");
        System.clearProperty("aims.autodetectBearerOnly");
        System.clearProperty("aims.alwaysRefreshToken");
        System.clearProperty("aims.principalAttribute");
        System.clearProperty("aims.enableBasicAuth");
    }

    private AIMSConfig initAIMSConfig() {
        AIMSConfig aimsConfig = new AIMSConfig();
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(CLASSPATH_SHARE_CONFIG_PROPERTIES);
            XMLConfigService configService = this.initXMLConfigServiceWithProperties(this.getConfigFiles(), resources);
            Assert.assertNotNull((Object)configService);
            Config config = configService.getConfig((Object)"AIMS");
            Assert.assertNotNull((Object)config);
            aimsConfig.setConfigService((ConfigService)configService);
            aimsConfig.init();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        return aimsConfig;
    }

    public void testDefaultPropertiesAreSetCorrectly() {
        this.clearSystemProperties();
        AIMSConfig aimsConfig = this.initAIMSConfig();
        Assert.assertFalse((boolean)aimsConfig.isEnabled());
    }
}

