/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.extensibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.ScriptRemote;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.Response;

public class SlingshotEvaluatorUtil {
    private static Log logger = LogFactory.getLog(SlingshotEvaluatorUtil.class);
    public static final String SITE_PRESET_CACHE = SlingshotEvaluatorUtil.class.getName() + ".sitePresets";
    protected static final String PORTLET_HOST = "portletHost";
    protected static final String PORTLET_URL = "portletUrl";
    protected static final String SITE_PRESET = "sitePreset";
    protected static final String SITE = "site";
    protected static final String PAGE_CONTEXT = "pagecontext";
    protected WebFrameworkServiceRegistry serviceRegistry = null;

    public void setServiceRegistry(WebFrameworkServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public String getEvaluatorParam(Map<String, String> params, String name, String defaultValue) {
        String value = params.get(name);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return defaultValue;
    }

    public Boolean getPortletHost(RequestContext context) {
        Boolean portletHost = (Boolean)context.getAttribute(PORTLET_HOST);
        if (portletHost == null) {
            String portletHostParam = context.getParameter(PORTLET_HOST);
            portletHost = portletHostParam != null && portletHostParam.equalsIgnoreCase("true");
        }
        return portletHost;
    }

    public String getPortletUrl(RequestContext context) {
        String portletUrl = (String)((Object)context.getAttribute(PORTLET_URL));
        if (portletUrl == null) {
            portletUrl = context.getParameter(PORTLET_URL);
        }
        return portletUrl;
    }

    public String getPageId(RequestContext context) {
        return context.getPageId();
    }

    public String getSite(RequestContext context) {
        String site = (String)context.getUriTokens().get(SITE);
        if (site == null) {
            site = context.getParameter(SITE);
        }
        if (site == null) {
            String[] pathNames = context.getUri().substring(context.getContextPath().length()).split("/");
            for (int i = 0; i < pathNames.length; ++i) {
                if (!pathNames[i].equals(SITE) || i + 1 >= pathNames.length) continue;
                site = pathNames[i + 1];
                break;
            }
        }
        return site;
    }

    public String getPageContext(RequestContext context) {
        String pageContext = (String)context.getUriTokens().get(PAGE_CONTEXT);
        if (pageContext == null) {
            pageContext = context.getParameter(PAGE_CONTEXT);
        }
        if (pageContext == null) {
            String[] pathNames = context.getUri().substring(context.getContextPath().length()).split("/");
            for (int i = 0; i < pathNames.length; ++i) {
                if (!pathNames[i].equals(PAGE_CONTEXT) || i + 1 >= pathNames.length) continue;
                pageContext = pathNames[i + 1];
                break;
            }
        }
        return pageContext;
    }

    public String getSitePreset(RequestContext context, String siteId) {
        String sitePresetId;
        block5: {
            HashMap<String, String> sitePresetCache = (HashMap<String, String>)context.getAttributes().get(SITE_PRESET_CACHE);
            if (sitePresetCache == null) {
                sitePresetCache = new HashMap<String, String>();
                context.getAttributes().put(SITE_PRESET_CACHE, sitePresetCache);
            }
            if ((sitePresetId = (String)sitePresetCache.get(siteId)) == null) {
                try {
                    org.json.JSONObject site = this.jsonGet("/api/sites/" + URLEncoder.encode((String)siteId));
                    if (site != null) {
                        sitePresetId = site.getString(SITE_PRESET);
                        sitePresetCache.put(siteId, sitePresetId);
                    }
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"Could not get a sitePreset from site json.");
                }
            }
        }
        return sitePresetId;
    }

    public org.json.JSONObject jsonGet(String uri) {
        block3: {
            ScriptRemote scriptRemote = this.serviceRegistry.getScriptRemote();
            Response response = scriptRemote.connect().get(uri);
            if (response.getStatus().getCode() == 200) {
                try {
                    return new org.json.JSONObject(response.getResponse());
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error((Object)("An error occurred when parsing response to json from the uri '" + uri + "': " + e.getMessage()));
                }
            }
        }
        return null;
    }

    public boolean isMemberOfGroups(RequestContext context, List<String> groups, boolean memberOfAllGroups) {
        Object _cachedGroupMemberships;
        RemoteConfigElement.EndpointDescriptor descriptor;
        Boolean isMember = null;
        HttpSession session = ServletUtil.getSession();
        JSONArray groupsList = null;
        String GROUP_MEMBERSHIPS = "AlfGroupMembershipsKey";
        String currentSite = this.getSite(context);
        boolean externalAuth = false;
        RemoteConfigElement config = (RemoteConfigElement)context.getServiceRegistry().getConfigService().getConfig((Object)"Remote").getConfigElement("remote");
        if (config != null && (descriptor = config.getEndpointDescriptor("alfresco")) != null) {
            externalAuth = descriptor.getExternalAuth();
        }
        if ((_cachedGroupMemberships = session.getAttribute(GROUP_MEMBERSHIPS)) instanceof JSONArray) {
            groupsList = (JSONArray)_cachedGroupMemberships;
        } else {
            try {
                CredentialVault cv = context.getCredentialVault();
                if (cv != null) {
                    String response;
                    JSONParser p;
                    Object o2;
                    Credentials creds = cv.retrieve("alfresco");
                    if (creds == null && !externalAuth) {
                        return false;
                    }
                    String userName = (String)session.getAttribute("_alf_USER_ID");
                    Connector connector = context.getServiceRegistry().getConnectorService().getConnector("alfresco", userName, ServletUtil.getSession());
                    Response res = connector.call("/api/people/" + URLEncoder.encode((String)context.getUserId()) + "?groups=true");
                    if (res.getStatus().getCode() == 200 && (o2 = (p = new JSONParser()).parse(response = res.getResponse())) instanceof JSONObject) {
                        JSONObject jsonRes = (JSONObject)o2;
                        groupsList = (JSONArray)jsonRes.get((Object)"groups");
                        session.setAttribute(GROUP_MEMBERSHIPS, (Object)groupsList);
                    }
                }
            }
            catch (ConnectorServiceException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        for (String groupName : groups) {
            boolean isMemberOfCurrentGroup;
            block22: {
                isMemberOfCurrentGroup = false;
                if (groupName != null) {
                    if (groupName.startsWith("Site")) {
                        if (currentSite == null) {
                            isMember = false;
                        } else {
                            try {
                                CredentialVault cv = context.getCredentialVault();
                                if (cv == null) break block22;
                                Credentials creds = cv.retrieve("alfresco");
                                if (creds == null && !externalAuth) {
                                    return false;
                                }
                                String userName = (String)session.getAttribute("_alf_USER_ID");
                                Connector connector = context.getServiceRegistry().getConnectorService().getConnector("alfresco", userName, ServletUtil.getSession());
                                Response res = connector.call("/api/sites/" + currentSite + "/memberships/" + URLEncoder.encode((String)context.getUserId()));
                                if (res.getStatus().getCode() == 200) {
                                    JSONParser p = new JSONParser();
                                    String response = res.getResponse();
                                    Object o2 = p.parse(response);
                                    if (!(o2 instanceof JSONObject)) break block22;
                                    JSONObject jsonRes = (JSONObject)o2;
                                    String siteMembership = (String)jsonRes.get((Object)"role");
                                    isMemberOfCurrentGroup = siteMembership.equals(groupName);
                                    break block22;
                                }
                                isMemberOfCurrentGroup = false;
                            }
                            catch (ConnectorServiceException e) {
                                e.printStackTrace();
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (groupsList != null) {
                        for (JSONObject group : groupsList) {
                            String currGroupName = group.get((Object)"itemName").toString();
                            if (!currGroupName.equals(groupName)) continue;
                            isMemberOfCurrentGroup = true;
                            break;
                        }
                    }
                }
            }
            if (!(memberOfAllGroups ? (isMember = Boolean.valueOf(isMember == null ? isMemberOfCurrentGroup : isMember != false && isMemberOfCurrentGroup)) == false : (isMember = Boolean.valueOf(isMember == null ? isMemberOfCurrentGroup : isMember != false || isMemberOfCurrentGroup)) != false)) continue;
            break;
        }
        return isMember;
    }

    public List<String> getGroups(String groupsParm) {
        ArrayList<String> groups = new ArrayList<String>();
        if (groupsParm != null) {
            String[] groupsArr;
            for (String group : groupsArr = groupsParm.split(",")) {
                groups.add(group.trim());
            }
        }
        return groups;
    }

    protected String getHeader(String name) {
        String header = null;
        if (name != null) {
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            header = rc.getHeader(name);
        }
        return header;
    }
}

