/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minidev.json.JSONObject;
import org.alfresco.web.site.TaskUtils;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.alfresco.web.site.servlet.config.AppConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class AppConfig {
    private static final Log logger = LogFactory.getLog(AppConfig.class);
    private final String realm;
    private final String clientId;
    private final String clientSecret;
    private final String authUrl;
    private final String principalAttribute;
    private final AIMSConfig aimsConfig;
    private static final String REALMS = "realms";
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> typeReference = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public AppConfig(AIMSConfig aimsConfig) {
        this.aimsConfig = aimsConfig;
        this.realm = aimsConfig.getRealm();
        this.clientId = aimsConfig.getResource();
        this.clientSecret = aimsConfig.getSecret();
        this.authUrl = aimsConfig.getAuthServerUrl();
        this.principalAttribute = aimsConfig.getPrincipalAttribute();
    }

    @Bean
    public OAuth2AuthorizedClientRepository authorizedClientRepository(@Autowired(required=false) OAuth2AuthorizedClientService authorizedClientService) {
        if (null != authorizedClientService) {
            return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
        }
        return null;
    }

    @Bean
    public OAuth2AuthorizedClientService authorizedClientService(@Autowired(required=false) ClientRegistrationRepository clientRegistrationRepository) {
        if (null != clientRegistrationRepository) {
            return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
        }
        return null;
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() throws ParseException {
        ClientRegistration clientRegistration = this.clientRegistration();
        if (null != clientRegistration) {
            return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
        }
        return null;
    }

    @Bean
    public AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceAndManager(@Autowired(required=false) ClientRegistrationRepository clientRegistrationRepository, @Autowired(required=false) OAuth2AuthorizedClientService authorizedClientService) {
        if (null != clientRegistrationRepository && null != authorizedClientService) {
            OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().build();
            AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientService);
            authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
            return authorizedClientManager;
        }
        return null;
    }

    private ClientRegistration clientRegistration() throws ParseException {
        if (this.aimsConfig.isEnabled()) {
            String realm_url = this.authUrl + "/realms/" + this.realm;
            String issuer = (String)AppConfig.getIssuer((URI)URI.create(realm_url), (String)this.realm).get();
            AtomicReference builder = new AtomicReference();
            TaskUtils.retry((int)10, (long)1000L, (Log)logger, () -> builder.set((ClientRegistration.Builder)AppConfig.getRfc8414Builder((URI)URI.create(issuer), (URI)URI.create(realm_url + "/.well-known/openid-configuration")).get()));
            return ((ClientRegistration.Builder)builder.get()).registrationId(this.clientId).clientId(this.clientId).clientSecret(this.clientSecret).scope(new String[]{"openid"}).redirectUri("*").userNameAttributeName(this.principalAttribute).clientAuthenticationMethod(org.springframework.security.oauth2.core.ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientName(this.clientId).build();
        }
        return null;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter(builder.build());
        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);
        return jsonConverter;
    }

    private static Optional<String> getIssuer(URI realm_url, String realm) throws ParseException {
        URI uri = UriComponentsBuilder.fromUri((URI)realm_url).replacePath(realm_url.getPath() + "/.well-known/openid-configuration").build(Collections.emptyMap());
        RequestEntity request = RequestEntity.get((URI)uri).build();
        String configuration = (String)rest.exchange(request, String.class).getBody();
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)configuration);
        return Optional.of(Optional.of(metadata).map(AuthorizationServerMetadata::getIssuer).map(Identifier::getValue).orElse(UriComponentsBuilder.fromUriString((String)realm_url.toString()).pathSegment(new String[]{"realms", realm}).build().toString()));
    }

    private static Supplier<ClientRegistration.Builder> getRfc8414Builder(URI issuer, URI uri) {
        return () -> {
            String userinfoEndpoint;
            RequestEntity request = RequestEntity.get((URI)uri).build();
            Map configuration = (Map)rest.exchange(request, typeReference).getBody();
            AuthorizationServerMetadata metadata = (AuthorizationServerMetadata)AppConfig.parse((Map)configuration, AuthorizationServerMetadata::parse);
            ClientRegistration.Builder builder = AppConfig.withProviderConfiguration((AuthorizationServerMetadata)metadata, (String)issuer.toASCIIString());
            URI jwkSetUri = metadata.getJWKSetURI();
            if (jwkSetUri != null) {
                builder.jwkSetUri(jwkSetUri.toASCIIString());
            }
            if ((userinfoEndpoint = (String)configuration.get("userinfo_endpoint")) != null) {
                builder.userInfoUri(userinfoEndpoint);
            }
            return builder;
        };
    }

    private static ClientRegistration.Builder withProviderConfiguration(AuthorizationServerMetadata metadata, String issuer) {
        String metadataIssuer = metadata.getIssuer().getValue();
        if (!issuer.equals(metadataIssuer)) {
            throw new IllegalStateException("The Issuer \"" + metadataIssuer + "\" provided in the configuration metadata did not match the requested issuer \"" + issuer + "\"");
        }
        String name = URI.create(issuer).getHost();
        org.springframework.security.oauth2.core.ClientAuthenticationMethod method = AppConfig.getClientAuthenticationMethod((String)issuer, (List)metadata.getTokenEndpointAuthMethods());
        List grantTypes = metadata.getGrantTypes();
        if (grantTypes != null && !grantTypes.contains(GrantType.AUTHORIZATION_CODE)) {
            throw new IllegalArgumentException("Only AuthorizationGrantType.AUTHORIZATION_CODE is supported. The issuer \"" + issuer + "\" returned a configuration of " + String.valueOf(grantTypes));
        }
        List scopes = AppConfig.getScopes((AuthorizationServerMetadata)metadata);
        LinkedHashMap configurationMetadata = new LinkedHashMap(metadata.toJSONObject());
        return ClientRegistration.withRegistrationId((String)name).userNameAttributeName("sub").scope((Collection)scopes).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(method).redirectUri("{baseUrl}/{action}/oauth2/code/{registrationId}").authorizationUri(metadata.getAuthorizationEndpointURI().toASCIIString()).providerConfigurationMetadata(configurationMetadata).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).clientName(issuer);
    }

    private static org.springframework.security.oauth2.core.ClientAuthenticationMethod getClientAuthenticationMethod(String issuer, List<ClientAuthenticationMethod> metadataAuthMethods) {
        if (metadataAuthMethods != null && !metadataAuthMethods.contains(ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            if (metadataAuthMethods.contains(ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
                return org.springframework.security.oauth2.core.ClientAuthenticationMethod.CLIENT_SECRET_POST;
            }
            if (metadataAuthMethods.contains(ClientAuthenticationMethod.NONE)) {
                return org.springframework.security.oauth2.core.ClientAuthenticationMethod.NONE;
            }
            throw new IllegalArgumentException("Only ClientAuthenticationMethod.BASIC, ClientAuthenticationMethod.POST and ClientAuthenticationMethod.NONE are supported. The issuer \"" + issuer + "\" returned a configuration of " + String.valueOf(metadataAuthMethods));
        }
        return org.springframework.security.oauth2.core.ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
    }

    private static List<String> getScopes(AuthorizationServerMetadata metadata) {
        Scope scope = metadata.getScopes();
        return scope == null ? Collections.singletonList("openid") : scope.toStringList();
    }

    private static <T> T parse(Map<String, Object> body, ThrowingFunction<JSONObject, T, ParseException> parser) {
        try {
            return (T)parser.apply((Object)new JSONObject(body));
        }
        catch (ParseException var3) {
            throw new RuntimeException(var3);
        }
    }
}

