/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.cmm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.web.cmm.CMMService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.util.XMLUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CMMServicePost
extends CMMService {
    private static final Log logger = LogFactory.getLog(CMMServicePost.class);

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "{\"success\":true}");
        try {
            JSONObject json = this.getJsonBody(req);
            if (json == null) {
                throw new IllegalArgumentException("No JSON body was provided.");
            }
            String modelName = (String)json.get((Object)"modelName");
            if (modelName == null || modelName.length() == 0) {
                throw new IllegalArgumentException("No 'modelName' was provided");
            }
            if (json.get((Object)"operation") != null) {
                result.put("result", this.serviceModelOperation(status, modelName, json));
            } else {
                String entityId = (String)json.get((Object)"entity");
                if (entityId != null && entityId.length() != 0) {
                    String form = (String)json.get((Object)"form");
                    String formOp = (String)json.get((Object)"formOperation");
                    CMMService.FormOperationEnum op = CMMService.FormOperationEnum.Update;
                    if (formOp != null && formOp.length() != 0) {
                        op = CMMService.FormOperationEnum.valueOf((String)formOp);
                    }
                    this.buildExtensionModule(status, modelName, new CMMService.FormOperation((CMMService)this, op, entityId, form));
                } else {
                    String formExtension = (String)json.get((Object)"forms");
                    if (formExtension != null && formExtension.length() != 0) {
                        HashMap<String, String> forms = new HashMap<String, String>();
                        Document doc = XMLUtil.parse((String)formExtension);
                        ArrayList<Element> formDefNodes = new ArrayList<Element>();
                        for (Object obj : doc.selectNodes("/module/configurations/config[@condition='FormDefinition']/form-definition")) {
                            formDefNodes.add((Element)obj);
                        }
                        if (formDefNodes != null) {
                            for (Element node : formDefNodes) {
                                forms.put(node.attributeValue("id"), node.getText());
                            }
                        }
                        this.buildExtensionModule(status, modelName, new CMMService.FormOperation((CMMService)this, CMMService.FormOperationEnum.Create, forms), false);
                    }
                }
            }
        }
        catch (IOException | DocumentException err) {
            this.errorResponse(status, err.getMessage());
        }
        return result;
    }
}

