/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator.doclib.action;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.json.simple.JSONObject;

public class EditableByCurrentUser
extends BaseEvaluator {
    private static final String PROP_WORKINGCOPYOWNER = "cm:workingCopyOwner";
    private static final String PROP_LOCKOWNER = "cm:lockOwner";
    private static final String PROP_LOCKTYPE = "cm:lockType";
    private static final String NODE_LOCK = "NODE_LOCK";

    public boolean evaluate(JSONObject jsonObject) {
        try {
            Object lockType = this.getProperty(jsonObject, PROP_LOCKTYPE);
            if (lockType != null && ((String)lockType).equalsIgnoreCase(NODE_LOCK)) {
                return false;
            }
            if (this.getIsLocked(jsonObject)) {
                return this.getMatchesCurrentUser(jsonObject, PROP_LOCKOWNER);
            }
            if (this.getIsWorkingCopy(jsonObject)) {
                return this.getMatchesCurrentUser(jsonObject, PROP_WORKINGCOPYOWNER);
            }
            return true;
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Failed to run UI evaluator: " + err.getMessage());
        }
    }
}

