/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import org.alfresco.web.config.forms.NodeMetadataBasedEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AspectEvaluator
extends NodeMetadataBasedEvaluator {
    protected static final String JSON_ASPECTS = "aspects";
    private static Log logger = LogFactory.getLog(AspectEvaluator.class);

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected boolean checkJsonAgainstCondition(String condition, String jsonResponseString) {
        boolean result;
        block3: {
            result = false;
            try {
                JSONObject json = new JSONObject(new JSONTokener(jsonResponseString));
                Object aspectsObj = json.get(JSON_ASPECTS);
                if (!(aspectsObj instanceof JSONArray)) break block3;
                JSONArray aspectsArray = (JSONArray)aspectsObj;
                for (int i = 0; i < aspectsArray.length(); ++i) {
                    String nextAspect = aspectsArray.getString(i);
                    if (!condition.equals(nextAspect)) continue;
                    result = true;
                    break;
                }
            }
            catch (JSONException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn((Object)"Failed to find aspects in JSON response from metadata service.", (Throwable)e);
            }
        }
        return result;
    }
}

