/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.packaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.util.VersionNumber;
import org.alfresco.web.config.packaging.ModulePackage;
import org.alfresco.web.config.packaging.ModulePackageDependency;
import org.alfresco.web.config.packaging.ModulePackageUsingProperties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModulePackageUsingProperties
implements ModulePackage {
    public static final String PROP_ID = "module.id";
    public static final String PROP_VERSION = "module.version";
    public static final String PROP_TITLE = "module.title";
    public static final String PROP_DESCRIPTION = "module.description";
    public static final String PROP_EDITIONS = "module.editions";
    public static final String PROP_REPO_VERSION_MIN = "module.repo.version.min";
    public static final String PROP_REPO_VERSION_MAX = "module.repo.version.max";
    public static final String PROP_DEPENDS_PREFIX = "module.depends.";
    public static final String PROP_SHARE_VERSION_MIN = "module.share.version.min";
    public static final String PROP_SHARE_VERSION_MAX = "module.share.version.max";
    private final Properties properties;
    private final List<ModulePackageDependency> dependencies = new ArrayList();

    protected ModulePackageUsingProperties(Properties properties) {
        this.validateProperties(properties);
        this.properties = properties;
    }

    public static ModulePackageUsingProperties loadFromResource(Resource resource) throws IOException {
        Properties props = new Properties();
        props.load(resource.getInputStream());
        return new ModulePackageUsingProperties(props);
    }

    protected void validateProperties(Properties props) {
        if (!props.containsKey("module.share.version.min") && props.containsKey("module.repo.version.min")) {
            props.setProperty("module.share.version.min", props.getProperty("module.repo.version.min"));
        }
        if (!props.containsKey("module.share.version.max") && props.containsKey("module.repo.version.max")) {
            props.setProperty("module.share.version.max", props.getProperty("module.repo.version.max"));
        }
        this.dependencies.addAll(ModulePackageUsingProperties.extractDependencies((Properties)props));
    }

    public String getId() {
        return this.properties.getProperty("module.id");
    }

    public String getTitle() {
        return this.properties.getProperty("module.title");
    }

    public String getDescription() {
        return this.properties.getProperty("module.description");
    }

    public ArtifactVersion getVersion() {
        String ver = this.properties.getProperty("module.version");
        if (StringUtils.isEmpty((Object)ver)) {
            return new DefaultArtifactVersion("0-ERROR_UNSET");
        }
        return new DefaultArtifactVersion(ver);
    }

    public VersionNumber getVersionMin() {
        String ver = this.properties.getProperty("module.share.version.min");
        if (StringUtils.isEmpty((Object)ver)) {
            return VersionNumber.VERSION_ZERO;
        }
        return new VersionNumber(ver);
    }

    public VersionNumber getVersionMax() {
        String ver = this.properties.getProperty("module.share.version.max");
        if (StringUtils.isEmpty((Object)ver)) {
            return VersionNumber.VERSION_BIG;
        }
        return new VersionNumber(ver);
    }

    public List<ModulePackageDependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ModulePackageUsingProperties{");
        sb.append("id='").append(this.getId()).append('\'');
        sb.append(", title='").append(this.getTitle()).append('\'');
        sb.append(", description='").append(this.getDescription()).append('\'');
        sb.append(", version=").append(this.getVersion());
        sb.append(", versionMin=").append(this.getVersionMin());
        sb.append(", versionMax=").append(this.getVersionMax());
        sb.append(", dependencies=").append(this.dependencies);
        sb.append('}');
        return sb.toString();
    }

    private static List<ModulePackageDependency> extractDependencies(Properties properties) {
        int prefixLength = "module.depends.".length();
        ArrayList<ModulePackageDependency> dependencies = new ArrayList<ModulePackageDependency>(2);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("module.depends.") || key.length() == prefixLength) continue;
            String dependencyId = key.substring(prefixLength);
            ModulePackageDependencyOnlyId dependency = new ModulePackageDependencyOnlyId(dependencyId);
            dependencies.add((ModulePackageDependency)dependency);
        }
        return dependencies;
    }
}

