/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.converter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.alfresco.encryptor.PublicPrivateKeyShareStringEncryptor;
import org.alfresco.web.site.servlet.config.AlfrescoEncryptionElementConvert;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.xml.XMLConfigService;

public class EncryptionElementConverterTest {
    protected XMLConfigService configService;
    protected Config globalConfig;
    protected ConfigElement globalConstraintHandlers;
    private static PublicPrivateKeyShareStringEncryptor encryptor = new PublicPrivateKeyShareStringEncryptor();
    private static String path = null;

    @BeforeClass
    public static void beforeClass() throws Exception {
        EncryptionElementConverterTest.setUpEncryptedKeys();
    }

    private static void setUpEncryptedKeys() {
        ClassLoader cl = EncryptionElementConverterTest.class.getClassLoader();
        URL uri = cl.getResource("alfresco/module/encryption");
        path = uri.getPath();
        encryptor.createKeyFiles(uri.getPath());
        encryptor.initPublic(uri.getPath());
        encryptor.initPrivate(uri.getPath());
    }

    @Test
    public void testBaseOperations() {
        String encryptedValue = encryptor.encrypt("123");
        Assert.assertEquals((Object)"123", (Object)encryptor.decrypt(encryptedValue));
    }

    @Test
    public void testEncryption() throws IOException {
        String encryptedSecret = encryptor.encrypt("secret");
        Assert.assertEquals((Object)"secret", (Object)encryptor.decrypt(encryptedSecret));
        PublicPrivateKeyShareStringEncryptor encryptorPrivateKey = new PublicPrivateKeyShareStringEncryptor();
        File file = new File(path);
        encryptorPrivateKey.initConfig(file.getAbsolutePath());
        Assert.assertEquals((Object)"secret", (Object)encryptorPrivateKey.decrypt(encryptedSecret));
    }

    @Test
    public void testEncryptionConverter() throws IOException {
        String encryptedValue = "ENC(" + encryptor.encrypt("secret") + ")";
        PublicPrivateKeyShareStringEncryptor encryptorPrivateKey = new PublicPrivateKeyShareStringEncryptor();
        File file = new File(path);
        encryptorPrivateKey.initConfig(file.getAbsolutePath());
        AlfrescoEncryptionElementConvert elementConveter = new AlfrescoEncryptionElementConvert(encryptorPrivateKey);
        Element elementEncrypted = DocumentHelper.createElement((String)"password");
        elementEncrypted.addText(encryptedValue);
        try {
            elementConveter.parse(elementEncrypted);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

