/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.packaging;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.VersionNumber;
import org.alfresco.web.config.packaging.ModulePackage;
import org.alfresco.web.config.packaging.ModulePackageDependency;
import org.alfresco.web.scripts.ShareManifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModulePackageHelper {
    private static Log logger = LogFactory.getLog(ModulePackageHelper.class);
    private static PropertyDescriptor[] descriptors;
    protected static final String REGEX_NUMBER_OR_DOT = "[0-9\\.]*";
    public static final String MANIFEST_SHARE = "Alfresco Share";

    public static Map<String, String> toMap(ModulePackage modulePackage) {
        HashMap<String, String> asMap = new HashMap<String, String>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            try {
                String propValue = String.valueOf(descriptors[i].getReadMethod().invoke((Object)modulePackage, new Object[0]));
                asMap.put(descriptors[i].getName(), propValue);
                continue;
            }
            catch (IllegalAccessException iae) {
                logger.error((Object)"Unable to turn ModulePackageUsingProperties into a Map ", (Throwable)iae);
                continue;
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"Unable to turn ModulePackageUsingProperties into a Map ", (Throwable)e);
            }
        }
        return asMap;
    }

    public static void checkValid(ModulePackage module, ShareManifest shareManifest) {
        ModulePackageHelper.checkVersions(new VersionNumber(shareManifest.getSpecificationVersion()), module);
    }

    protected static List<String> toIds(List<ModulePackage> mods) {
        ArrayList<String> ids = new ArrayList<String>(mods.size());
        for (ModulePackage mod : mods) {
            ids.add(mod.getId());
        }
        return ids;
    }

    protected static void checkVersions(VersionNumber warVersion, ModulePackage installingModuleDetails) {
        if (warVersion.compareTo(installingModuleDetails.getVersionMin()) == -1) {
            throw new AlfrescoRuntimeException("The module (" + installingModuleDetails.getTitle() + ") must be installed on a Share version equal to or greater than " + String.valueOf(installingModuleDetails.getVersionMin()) + ". Share is version: " + String.valueOf(warVersion) + ".");
        }
        if (warVersion.compareTo(installingModuleDetails.getVersionMax()) == 1) {
            throw new AlfrescoRuntimeException("The module (" + installingModuleDetails.getTitle() + ") cannot be installed on a Share version greater than " + String.valueOf(installingModuleDetails.getVersionMax()) + ". Share is version: " + String.valueOf(warVersion) + ".");
        }
    }

    protected static void checkDependencies(ModulePackage module, List<ModulePackage> availableModules) {
        List<ModulePackageDependency> dependencies = module.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            List<String> moduleIds = ModulePackageHelper.toIds(availableModules);
            ArrayList<ModulePackageDependency> missingDependencies = new ArrayList<ModulePackageDependency>(0);
            for (ModulePackageDependency dependency : dependencies) {
                if (moduleIds.contains(dependency.getId())) continue;
                missingDependencies.add(dependency);
            }
            if (!missingDependencies.isEmpty()) {
                throw new AlfrescoRuntimeException("The module (" + module.getTitle() + ") cannot be installed. The following modules must first be installed: " + String.valueOf(missingDependencies));
            }
        }
    }

    static {
        try {
            BeanInfo moduleinfo = Introspector.getBeanInfo(ModulePackage.class);
            descriptors = moduleinfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            logger.error((Object)"Unable to read bean info for ModulePackage");
        }
    }
}

