/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import org.alfresco.web.site.DocsEdition;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

public class DocsEditionTest {
    private DocsEdition edition;

    @Test
    public void getValueReturnsCommunityWhenEditionUNKNOWN() throws JSONException {
        this.edition = new DocsEdition("UNKNOWN", null, false);
        Assert.assertEquals((Object)"community", (Object)this.edition.getValue());
        this.edition = new DocsEdition();
        Assert.assertEquals((Object)"community", (Object)this.edition.getValue());
    }

    @Test
    public void getValueReturnsCommunityWhenEditionEnterpriseButSpecificationVersionUnknown() throws JSONException {
        this.edition = new DocsEdition("ENTERPRISE", null, false);
        Assert.assertEquals((Object)"community", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "", false);
        Assert.assertEquals((Object)"community", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "abc", false);
        Assert.assertEquals((Object)"community", (Object)this.edition.getValue());
    }

    @Test
    public void getValueReturnsVersionWhenEditionIsInCloud() throws JSONException {
        this.edition = new DocsEdition(true);
        Assert.assertEquals((Object)"cloud", (Object)this.edition.getValue());
        this.edition = new DocsEdition("UNKNOWN", null, true);
        Assert.assertEquals((Object)"cloud", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "5.1.0", true);
        Assert.assertEquals((Object)"cloud", (Object)this.edition.getValue());
    }

    @Test
    public void getValueReturnsVersionWhenEditionENTERPRISE() throws JSONException {
        this.edition = new DocsEdition("ENTERPRISE", "5.1.0", false);
        Assert.assertEquals((Object)"5.1", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "5.1-SNAPSHOT", false);
        Assert.assertEquals((Object)"5.1", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "5.1", false);
        Assert.assertEquals((Object)"5.1", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "10.10.10", false);
        Assert.assertEquals((Object)"10.10", (Object)this.edition.getValue());
        this.edition = new DocsEdition("ENTERPRISE", "10.10", false);
        Assert.assertEquals((Object)"10.10", (Object)this.edition.getValue());
    }
}

