/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.processor.BaseProcessorExtension;

public class UserPreferences
extends BaseProcessorExtension {
    private static final String USER_PREFERENCES = "_alfUserPreferences";

    public String getValue() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        String prefs = (String)((Object)rc.getValue(USER_PREFERENCES));
        if (prefs == null) {
            prefs = "{}";
            if (!AuthenticationUtil.isGuest((String)rc.getUserId())) {
                try {
                    Connector conn = rc.getServiceRegistry().getConnectorService().getConnector("alfresco", rc.getUserId(), ServletUtil.getSession());
                    Response response = conn.call("/api/people/" + URLEncoder.encode((String)rc.getUserId()) + "/preferences");
                    if (response.getStatus().getCode() == 200) {
                        prefs = response.getResponse();
                        rc.setValue(USER_PREFERENCES, (Serializable)((Object)prefs));
                    }
                }
                catch (ConnectorServiceException e) {
                    throw new AlfrescoRuntimeException("Unable to retrieve user preferences: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return prefs;
    }
}

