/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.alfresco.web.site.servlet.MTAuthenticationFilter;
import org.apache.commons.codec.binary.Base64;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.webscripts.RequestCachingConnector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.RemoteClient;

public class SlingshotAlfrescoConnector
extends RequestCachingConnector {
    private static final String CD_USER_HEADER = "userHeader";
    private static final String CD_USER_ID_PATTERN = "userIdPattern";
    public static final String CS_PARAM_USER_HEADER = "userHeader";
    public static final String CS_PARAM_USER_ID_PATTERN = "userIdPattern";

    public SlingshotAlfrescoConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        super(descriptor, endpoint);
    }

    private String getUserHeader() {
        String userHeader = this.descriptor.getStringProperty("userHeader");
        if (userHeader != null && userHeader.trim().length() == 0) {
            userHeader = null;
        }
        return userHeader;
    }

    private String getUserIdPattern() {
        String userIdPattern = this.descriptor.getStringProperty("userIdPattern");
        if (userIdPattern != null && userIdPattern.trim().length() == 0) {
            userIdPattern = null;
        }
        return userIdPattern;
    }

    public void setConnectorSession(ConnectorSession connectorSession) {
        super.setConnectorSession(connectorSession);
        connectorSession.setParameter("userHeader", this.getUserHeader());
        connectorSession.setParameter("userIdPattern", this.getUserIdPattern());
    }

    protected void applyRequestHeaders(RemoteClient remoteClient, ConnectorContext context) {
        String userHeader;
        ConnectorSession connectorSession = this.getConnectorSession();
        if (connectorSession != null) {
            HashMap<String, String> cookies = new HashMap<String, String>(8);
            for (String cookieName : connectorSession.getCookieNames()) {
                cookies.put(cookieName, connectorSession.getCookie(cookieName));
            }
            remoteClient.setCookies(cookies);
        }
        HashMap<String, String> headers = new HashMap<String, String>(8);
        if (context != null) {
            headers.putAll(context.getHeaders());
        }
        if (this.getCredentials() != null && (userHeader = this.getUserHeader()) != null) {
            HttpServletRequest req = ServletUtil.getRequest();
            if (req == null) {
                req = MTAuthenticationFilter.getCurrentServletRequest();
            }
            String user = null;
            if (req != null && (user = req.getHeader(userHeader)) == null) {
                user = req.getRemoteUser();
            }
            if (user != null) {
                if (!Base64.isBase64((String)user)) {
                    try {
                        user = Base64.encodeBase64String((byte[])new String(user.getBytes("ISO-8859-1"), "UTF-8").getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    headers.put("Remote-User-Encode", Boolean.TRUE.toString());
                }
                headers.put(userHeader, user);
            }
        }
        if (headers.size() != 0) {
            remoteClient.setRequestProperties(headers);
        }
    }
}

