/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.cmis;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.cmis.CMISConnection;
import org.springframework.extensions.cmis.CMISConnectionManagerImpl;
import org.springframework.extensions.cmis.CMISScriptParameterFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.AuthenticatingConnector;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.Credentials;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlingshotCMISScriptParameterFactory
extends CMISScriptParameterFactory {
    private static final Log logger = LogFactory.getLog(SlingshotCMISScriptParameterFactory.class);
    private static final String CMIS_PATH = "/cmisatom";
    private static final String ALFRESCO_SERVICE_BASE_PATH = "/s";
    private ConnectorService connectorService;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMISConnection getConnection(CMISConnectionManagerImpl connectionManager) {
        this.lock.writeLock().lock();
        try {
            Connector connector;
            CMISConnection connection = super.getConnection(connectionManager);
            if (connection != null) {
                CMISConnection cMISConnection = connection;
                return cMISConnection;
            }
            if (ThreadLocalRequestContext.getRequestContext() == null) {
                CMISConnection cMISConnection = null;
                return cMISConnection;
            }
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            Credentials creds = rc.getCredentialVault().retrieve("alfresco");
            try {
                connector = this.connectorService.getConnector("alfresco");
                connector.setCredentials(creds);
            }
            catch (Exception e) {
                logger.info((Object)("Unable to get endpoint connector: " + String.valueOf(e)), (Throwable)e);
                CMISConnection cMISConnection = null;
                this.lock.writeLock().unlock();
                return cMISConnection;
            }
            String alfrescoEndpointUrl = connector.getEndpoint();
            if (alfrescoEndpointUrl.endsWith("/s")) {
                alfrescoEndpointUrl = alfrescoEndpointUrl.substring(0, alfrescoEndpointUrl.length() - "/s".length());
            }
            String url = alfrescoEndpointUrl + "/cmisatom";
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("name", "default-" + rc.getUserId());
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
            parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", AlfrescoObjectFactoryImpl.class.getName());
            String ticket = this.getTicket(connector);
            if (ticket != null) {
                parameters.put("org.apache.chemistry.opencmis.user", "");
                parameters.put("org.apache.chemistry.opencmis.password", ticket);
            } else if (creds != null) {
                parameters.put("org.apache.chemistry.opencmis.user", (String)creds.getProperty("cleartextUsername"));
                parameters.put("org.apache.chemistry.opencmis.password", (String)creds.getProperty("cleartextPassword"));
            } else {
                CMISConnection cMISConnection = null;
                return cMISConnection;
            }
            CMISConnection cMISConnection = this.createDefaultConnection(connectionManager, SlingshotCMISScriptParameterFactory.createServerDefinition(parameters));
            return cMISConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String getTicket(Connector connector) {
        String ticket = connector.getConnectorSession().getParameter("alfTicket");
        if (ticket != null) {
            return ticket;
        }
        if (connector instanceof AuthenticatingConnector && ((AuthenticatingConnector)connector).handshake()) {
            return connector.getConnectorSession().getParameter("alfTicket");
        }
        return null;
    }
}

