/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.packaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.config.packaging.ModulePackage;
import org.alfresco.web.config.packaging.ModulePackageHelper;
import org.alfresco.web.config.packaging.ModulePackageUsingProperties;
import org.alfresco.web.scripts.ShareManifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModulePackageManager
implements InitializingBean {
    public static final String MODULE_RESOURCES = "classpath*:alfresco/module/*/module.properties";
    private static Log logger = LogFactory.getLog(ModulePackageManager.class);
    private ShareManifest shareManifest;
    private List<ModulePackage> modules = new ArrayList();

    protected List<ModulePackage> resolveModules(String resourcePath) {
        Assert.notNull((Object)resourcePath, (String)"Resource path must not be null");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<ModulePackage> modulesFound = new ArrayList<ModulePackage>();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(resourcePath)) {
                ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
                if (mp == null) continue;
                modulesFound.add(mp);
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Unable to resolve modules ", (Throwable)ioe);
        }
        return modulesFound;
    }

    protected static ModulePackage asModulePackage(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        try {
            return ModulePackageUsingProperties.loadFromResource((Resource)resource);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load resource " + resource.toString()), (Throwable)e);
            return null;
        }
    }

    protected String writeModuleList(List<ModulePackage> foundModules) {
        StringBuilder b = new StringBuilder(128);
        for (ModulePackage module : foundModules) {
            b.append(module.getTitle()).append(", " + String.valueOf(module.getVersion())).append(", " + module.getDescription());
            b.append("\n");
        }
        return b.toString();
    }

    public List<ModulePackage> getModulePackages() {
        return this.modules;
    }

    public void afterPropertiesSet() {
        logger.debug((Object)"Resolving module packages.");
        this.modules = this.resolveModules("classpath*:alfresco/module/*/module.properties");
        String moduleList = this.writeModuleList(this.modules);
        if (!this.modules.isEmpty()) {
            logger.info((Object)("Found " + this.modules.size() + " module package(s)"));
            logger.info((Object)moduleList);
            for (ModulePackage module : this.modules) {
                ModulePackageHelper.checkValid((ModulePackage)module, (ShareManifest)this.shareManifest);
                ModulePackageHelper.checkDependencies((ModulePackage)module, (List)this.modules);
            }
        }
    }

    public void setShareManifest(ShareManifest shareManifest) {
        this.shareManifest = shareManifest;
    }
}

