/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.processor.BaseProcessorExtension;

public abstract class SingletonValueProcessorExtension<T>
extends BaseProcessorExtension {
    private final Map<String, T> storeValues = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    protected final T getSingletonValue() {
        return (T)this.getSingletonValue(false);
    }

    protected final T getSingletonValue(boolean tenant) {
        return (T)this.getSingletonValue(tenant, ThreadLocalRequestContext.getRequestContext().getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getSingletonValue(boolean tenant, String userId) {
        Object result;
        block10: {
            String storeId = tenant ? this.getTenantUserStore(userId) : "";
            this.lock.readLock().lock();
            try {
                result = this.storeValues.get(storeId);
                if (result != null) break block10;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    result = this.storeValues.get(storeId);
                    if (result == null) {
                        result = this.retrieveValue(userId, storeId);
                        this.storeValues.put(storeId, result);
                    }
                }
                catch (ConnectorServiceException cerr) {
                    throw new AlfrescoRuntimeException("Unable to retrieve " + this.getValueName() + " configuration from Alfresco: " + cerr.getMessage());
                }
                catch (Exception err) {
                    throw new AlfrescoRuntimeException("Failed during processing of " + this.getValueName() + " configuration from Alfresco: " + err.getMessage());
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasSingletonValue(boolean tenant, String userId) {
        boolean result = false;
        String storeId = tenant ? this.getTenantUserStore(userId) : "";
        this.lock.readLock().lock();
        try {
            result = this.storeValues.get(storeId) != null;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    protected abstract T retrieveValue(String var1, String var2) throws ConnectorServiceException;

    protected abstract String getValueName();

    private final String getTenantUserStore(String userId) {
        if (userId == null || AuthenticationUtil.isGuest((String)userId)) {
            throw new AlfrescoRuntimeException("User ID must exist and cannot be guest.");
        }
        String storeId = "";
        int idx = userId.indexOf(64);
        if (idx != -1) {
            storeId = userId.substring(idx);
        }
        return storeId;
    }
}

