/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.extensibility;

import java.util.List;
import java.util.Map;
import org.alfresco.web.extensibility.SlingshotEvaluatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.ExtensionModuleEvaluator;

public class SlingshotSiteModuleEvaluator
implements ExtensionModuleEvaluator {
    private static Log logger = LogFactory.getLog(SlingshotSiteModuleEvaluator.class);
    public static final String SITE_PRESET_FILTER = "sitePresets";
    public static final String SITE_FILTER = "sites";
    public static final String APPLY_FOR_NON_SITES = "applyForNonSites";
    public static final String GROUPS = "groups";
    public static final String GROUPS_RELATION = "groupsRelation";
    public static final String GROUPS_RELATION_AND = "AND";
    protected SlingshotEvaluatorUtil util = null;

    public void setSlingshotEvaluatorUtil(SlingshotEvaluatorUtil slingshotExtensibilityUtil) {
        this.util = slingshotExtensibilityUtil;
    }

    public String[] getRequiredProperties() {
        String[] properties = new String[]{SITE_PRESET_FILTER, SITE_FILTER};
        return properties;
    }

    public boolean applyModule(RequestContext context, Map<String, String> params) {
        String siteId = this.util.getSite(context);
        if (siteId != null) {
            if (!siteId.matches(this.util.getEvaluatorParam(params, SITE_FILTER, ".*"))) {
                return false;
            }
            String sitePreset = this.util.getSitePreset(context, siteId);
            if (sitePreset == null || !sitePreset.matches(this.util.getEvaluatorParam(params, SITE_PRESET_FILTER, ".*"))) {
                return false;
            }
            return this.isUserInGroups(context, params);
        }
        if (!this.util.getEvaluatorParam(params, APPLY_FOR_NON_SITES, "true").equals("true")) {
            return false;
        }
        return this.isUserInGroups(context, params);
    }

    protected boolean isUserInGroups(RequestContext context, Map<String, String> params) {
        String groupsParam = this.util.getEvaluatorParam(params, GROUPS, ".*");
        if (groupsParam.equals(".*")) {
            return true;
        }
        String relationParam = params.get(GROUPS_RELATION);
        boolean memberOfAllGroups = relationParam != null && relationParam.trim().equalsIgnoreCase(GROUPS_RELATION_AND);
        List<String> groups = this.util.getGroups(groupsParam);
        return this.util.isMemberOfGroups(context, groups, memberOfAllGroups);
    }
}

