/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.packaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.util.VersionNumber;
import org.alfresco.web.config.packaging.ModulePackage;
import org.alfresco.web.config.packaging.ModulePackageHelper;
import org.alfresco.web.config.packaging.ModulePackageHelperTest;
import org.alfresco.web.config.packaging.ModulePackageManager;
import org.alfresco.web.config.packaging.ModulePackageUsingProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.Resource;

public class ModulePackageManagerTest
extends ModulePackageHelperTest {
    private static Log logger = LogFactory.getLog(ModulePackageManagerTest.class);

    @Test
    public void testResolveModules() {
        ModulePackageManager mpm = ModulePackageManagerTest.setup();
        List mods = mpm.resolveModules("classpath*:NOFresco/module/*/module.properties");
        Assert.assertTrue((String)"No modules should be found", (boolean)mods.isEmpty());
        mods = mpm.resolveModules("classpath*:alfresco/module/*/module.properties");
        Assert.assertFalse((String)"Modules should be found", (boolean)mods.isEmpty());
        Assert.assertEquals((long)3L, (long)mods.size());
        List ids = ModulePackageHelper.toIds((List)mods);
        Assert.assertTrue((boolean)ids.contains("module-list"));
        Assert.assertTrue((boolean)ids.contains("user-admin"));
        Assert.assertTrue((boolean)ids.contains("pentaho-share"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolveModulesErrors() {
        ModulePackageManager mpm = ModulePackageManagerTest.setup();
        mpm.resolveModules(null);
    }

    @Test
    public void testAsModulePackage() {
        Resource resource = loader.getResource("classpath:alfresco/module/simple/simplemodule.properties");
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        logger.debug((Object)("Simple module:" + mp.toString()));
        Assert.assertEquals((Object)"Alfresco JAR Module Project", (Object)mp.getTitle());
        Assert.assertEquals((Object)"alfresco-simple-module", (Object)mp.getId());
        Assert.assertEquals((Object)"UNSUPPORTED experiment", (Object)mp.getDescription());
        Assert.assertTrue((boolean)new DefaultArtifactVersion("1.0-SNAPSHOT").equals((Object)mp.getVersion()));
        ModulePackageUsingProperties mpup = (ModulePackageUsingProperties)mp;
        Map asMap = ModulePackageHelper.toMap((ModulePackage)mpup);
        Assert.assertEquals((Object)"Alfresco JAR Module Project", asMap.get("title"));
        Assert.assertEquals((Object)"alfresco-simple-module", asMap.get("id"));
        Assert.assertEquals((Object)"UNSUPPORTED experiment", asMap.get("description"));
        Assert.assertEquals((Object)"1.0-SNAPSHOT", asMap.get("version"));
        resource = loader.getResource("classpath:alfresco/module/bad/badmodule.properties");
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        logger.debug((Object)("Bad module:" + mp.toString()));
        Assert.assertEquals((Object)"Alfresco Bad Module", (Object)mp.getTitle());
        Assert.assertNull((String)"A bad module with no id.", (Object)mp.getId());
        Assert.assertNull((String)"A bad module with no desc.", (Object)mp.getDescription());
        Assert.assertTrue((boolean)new DefaultArtifactVersion("0-ERROR_UNSET").equals((Object)mp.getVersion()));
        mpup = (ModulePackageUsingProperties)mp;
        asMap = ModulePackageHelper.toMap((ModulePackage)mpup);
        Assert.assertEquals((Object)"Alfresco Bad Module", asMap.get("title"));
        Assert.assertEquals((Object)"null", asMap.get("id"));
        Assert.assertEquals((Object)"null", asMap.get("description"));
        Assert.assertEquals((Object)"0-ERROR_UNSET", asMap.get("version"));
    }

    @Test
    public void testBadAsModulePackage() {
        ModulePackageManager mpm = ModulePackageManagerTest.setup();
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)loader.getResource("nonsense.txt"));
        Assert.assertNull((Object)mp);
        List packs = mpm.resolveModules("not any.txt");
        Assert.assertEquals((long)0L, (long)packs.size());
    }

    @Test
    public void testWriteModuleList() {
        List mods;
        ModulePackageManager mpm = ModulePackageManagerTest.setup();
        String moduleList = mpm.writeModuleList(mods = new ArrayList());
        Assert.assertTrue((String)"No Modules found so an empty string.", (moduleList.length() == 0 ? 1 : 0) != 0);
        mods = mpm.resolveModules("classpath*:alfresco/module/*/module.properties");
        moduleList = mpm.writeModuleList(mods);
        logger.debug((Object)moduleList);
        Assert.assertTrue((boolean)moduleList.contains("User admin project"));
    }

    @Test
    public void testModuleShareVersions() {
        Resource resource = loader.getResource("classpath:alfresco/module/simple/simplemodule.properties");
        ModulePackage mp = ModulePackageManager.asModulePackage((Resource)resource);
        Assert.assertEquals((Object)"alfresco-simple-module", (Object)mp.getId());
        Assert.assertEquals((Object)"2.0", (Object)mp.getVersionMin().toString());
        Assert.assertEquals((Object)"2.1", (Object)mp.getVersionMax().toString());
        resource = loader.getResource("classpath:alfresco/module/bad/badmodule.properties");
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        Assert.assertEquals((Object)"Alfresco Bad Module", (Object)mp.getTitle());
        Assert.assertEquals((Object)VersionNumber.VERSION_ZERO, (Object)mp.getVersionMin());
        Assert.assertEquals((Object)VersionNumber.VERSION_BIG, (Object)mp.getVersionMax());
        resource = loader.getResource("classpath:alfresco/module/pent/module.properties");
        mp = ModulePackageManager.asModulePackage((Resource)resource);
        Assert.assertEquals((Object)"pentaho-share", (Object)mp.getId());
        Assert.assertEquals((Object)"5.0", (Object)mp.getVersionMin().toString());
        Assert.assertEquals((Object)"5.999", (Object)mp.getVersionMax().toString());
    }

    @Test
    public void testAfterPropertiesSet() {
        ModulePackageManager mpm = ModulePackageManagerTest.setup();
        mpm.setShareManifest(shareManifest);
        mpm.afterPropertiesSet();
        Assert.assertNotNull((Object)mpm.getModulePackages());
    }
}

