/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.cmm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.web.cmm.CMMService;
import org.alfresco.web.scripts.DictionaryQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CMMDictionaryGet
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(CMMDictionaryGet.class);
    protected DictionaryQuery dictionary;

    public void setDictionary(DictionaryQuery dictionary) {
        this.dictionary = dictionary;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] classes = null;
        String entity = (String)req.getServiceMatch().getTemplateVars().get("entity");
        if (entity != null && entity.length() != 0) {
            classes = this.dictionary.getSubTypes(entity);
        } else {
            String[] classtype = (String[])req.getServiceMatch().getTemplateVars().get("classtype");
            if (classtype != null) {
                switch (classtype) {
                    case "aspects": {
                        classes = this.dictionary.getAllAspects();
                        break;
                    }
                    case "types": {
                        classes = this.dictionary.getAllTypes();
                    }
                }
            }
        }
        if (classes == null) {
            throw new IllegalArgumentException("No valid entity or types/aspects modifier specified.");
        }
        ArrayList<CMMService.TWrapper> entities = new ArrayList<CMMService.TWrapper>();
        for (String e : classes) {
            entities.add(new CMMService.TWrapper(4).put("name", (Object)e).put("title", (Object)this.dictionary.getTitle(e)).put("description", (Object)this.dictionary.getDescription(e)));
        }
        result.put("entities", entities);
        return result;
    }
}

