/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator;

import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.alfresco.web.scripts.DictionaryQuery;
import org.json.simple.JSONObject;

public class NodeTypeEvaluator
extends BaseEvaluator {
    private DictionaryQuery dictionary;
    private boolean allowSubtypes = true;
    private ArrayList<String> types;

    public void setDictionary(DictionaryQuery dictionary) {
        this.dictionary = dictionary;
    }

    public void setAllowSubtypes(boolean allowSubtypes) {
        this.allowSubtypes = allowSubtypes;
    }

    public void setTypes(ArrayList<String> types) {
        this.types = types;
    }

    @Override
    public boolean evaluate(JSONObject jsonObject) {
        if (this.types.size() == 0) {
            return false;
        }
        String nodeType = this.getNodeType(jsonObject);
        try {
            if (this.types.contains(nodeType)) {
                return true;
            }
            if (this.allowSubtypes && this.dictionary != null) {
                for (String type : this.types) {
                    if (!this.dictionary.isSubType(nodeType, type)) continue;
                    return true;
                }
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Failed to run action evaluator: " + err.getMessage());
        }
        return false;
    }
}

