/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator.doclib.indicator;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LockOwnerEvaluator
extends BaseEvaluator {
    private static final String ASPECT_TRANSFERRED = "trx:transferred";
    private static final String ASPECT_WORKINGCOPY = "cm:workingcopy";
    private static final String PROP_LOCKOWNER = "cm:lockOwner";

    public boolean evaluate(JSONObject jsonObject) {
        try {
            if (this.getIsLocked(jsonObject)) {
                JSONArray nodeAspects = this.getNodeAspects(jsonObject);
                if (nodeAspects == null) {
                    return false;
                }
                if (!nodeAspects.contains((Object)ASPECT_TRANSFERRED) && !nodeAspects.contains((Object)ASPECT_WORKINGCOPY)) {
                    return this.getMatchesCurrentUser(jsonObject, PROP_LOCKOWNER);
                }
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Failed to run UI evaluator: " + err.getMessage());
        }
        return false;
    }
}

