/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.cmis;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.springframework.extensions.cmis.CMISConnection;
import org.springframework.extensions.cmis.CMISConnectionManagerImpl;
import org.springframework.extensions.cmis.CMISScriptParameterFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class CMISContentStreamWebScript
extends AbstractWebScript {
    public static final String DOC_ID = "id";
    public static final String STREAM_ID = "stream";
    public static final String CONNECTION = "conn";
    private CMISScriptParameterFactory scriptParameterFactory;

    public void setScriptParameterFactory(CMISScriptParameterFactory scriptParameterFactory) {
        this.scriptParameterFactory = scriptParameterFactory;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        long length;
        ContentStream stream;
        CmisObject object;
        CMISConnection conn = null;
        String docId = req.getParameter(DOC_ID);
        String streamId = req.getParameter(STREAM_ID);
        String connectionId = req.getParameter(CONNECTION);
        conn = connectionId != null ? this.scriptParameterFactory.getConnection(new CMISConnectionManagerImpl(this.scriptParameterFactory, req.getRuntime()), connectionId) : this.scriptParameterFactory.getConnection(new CMISConnectionManagerImpl(this.scriptParameterFactory, req.getRuntime()));
        if (conn == null) {
            throw new WebScriptException(500, "Invalid connection!");
        }
        Session session = conn.getSession();
        try {
            object = session.getObject(docId);
        }
        catch (CmisBaseException e) {
            if (e instanceof CmisObjectNotFoundException) {
                throw new WebScriptException(404, "Object not found!", (Throwable)e);
            }
            throw new WebScriptException(500, e.getMessage(), (Throwable)e);
        }
        if (!(object instanceof Document)) {
            throw new WebScriptException(404, "Object is not a document!");
        }
        Document document = (Document)object;
        ContentStream contentStream = stream = streamId == null ? document.getContentStream() : document.getContentStream(streamId);
        if (stream.getMimeType() != null) {
            res.setContentType(stream.getMimeType());
        }
        if ((length = stream.getLength()) != -1L) {
            res.setHeader("Content-Length", Long.toString(length));
        }
        FileCopyUtils.copy((InputStream)stream.getStream(), (OutputStream)res.getOutputStream());
    }
}

