/*
 * Copyright (C) 2005-2015 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.springframework.extensions.surf.webscripts;

import java.util.HashMap;
import java.util.Map;

import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ToggleSurfBugPOST extends ToggleSurfBug
{
    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache)
    {
        String surfBugStatusUpdate = req.getParameter(UPDATE_STATUS_REQUEST_PARAMETER);
        this.webFrameworkConfigElement.setSurfBugEnabled(surfBugStatusUpdate != null && surfBugStatusUpdate.equals(DEBUG_ENABLED));
        
        Map<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("surfbugEnabled", this.webFrameworkConfigElement.isSurfBugEnabled());
        return model;
    }
}
