/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractWebFrameworkController
extends AbstractController
implements ServletContextAware {
    private static final String MIMETYPE_HTML = "text/html;charset=utf-8";
    private WebFrameworkServiceRegistry webFrameworkServiceRegistry;

    public void setServiceRegistry(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        this.webFrameworkServiceRegistry = webFrameworkServiceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.webFrameworkServiceRegistry;
    }

    public WebFrameworkConfigElement getWebFrameworkConfiguration() {
        return this.getServiceRegistry().getWebFrameworkConfiguration();
    }

    public ModelObjectService getObjectService() {
        return this.getServiceRegistry().getModelObjectService();
    }

    public RenderService getRenderService() {
        return this.getServiceRegistry().getRenderService();
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            String qs = request.getQueryString();
            this.getLogger().debug((Object)("Processing URL: (" + request.getMethod() + ") " + request.getRequestURI() + (String)(qs != null && qs.length() != 0 ? "?" + qs : "")));
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setContentType(MIMETYPE_HTML);
        return this.createModelAndView(request, response);
    }

    public abstract ModelAndView createModelAndView(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract Log getLogger();
}

