/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.DependencyDeferredContentSourceModelElement;
import org.springframework.extensions.directives.DependencyDeferredContentTargetModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;

public class OutputJavaScriptContentModelElement
extends DependencyDeferredContentTargetModelElement {
    private static final Log logger = LogFactory.getLog(OutputJavaScriptContentModelElement.class);
    private String resourceControllerMapping = null;
    private DependencyAggregator dependencyAggregator;
    private WebFrameworkConfigElement webFrameworkConfig;
    private static final String TYPE = "DependencyContent";
    private LinkedHashMap<String, LinkedHashSet<String>> javaScriptFiles = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashSet<String>> aggJavaScriptFiles = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashSet<String>> dojoNonAmdFiles = new LinkedHashMap();

    public OutputJavaScriptContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator, WebFrameworkConfigElement webFrameworkConfig) {
        super(id, directiveName);
        this.dependencyAggregator = dependencyAggregator;
        this.webFrameworkConfig = webFrameworkConfig;
        this.resourceControllerMapping = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyAggregator.getDependencyHandler().getResourceControllerMapping() + "/";
    }

    @Override
    protected String getResourceControllerMapping() {
        return this.resourceControllerMapping;
    }

    public String getType() {
        return TYPE;
    }

    public LinkedHashMap<String, LinkedHashSet<String>> getDojoNonAmdFiles() {
        return this.dojoNonAmdFiles;
    }

    public void addJavaScriptFile(String fileName, String groupName, boolean forAggregation) {
        if (fileName.startsWith(">>>")) {
            if (forAggregation) {
                this.addJavaScriptFile(fileName, groupName, this.aggJavaScriptFiles);
            } else {
                this.addJavaScriptFile(fileName, groupName, this.javaScriptFiles);
            }
        } else if (!this.dependencyAlreadyRequested(fileName = this.normaliseDependency(fileName))) {
            this.markDependencyAsRequested(fileName);
            if (forAggregation) {
                this.addJavaScriptFile(fileName, groupName, this.aggJavaScriptFiles);
            } else {
                String checksumPath = this.dependencyAggregator.getDependencyHandler().getChecksumPath(fileName);
                if (checksumPath.toLowerCase().startsWith("http://") || checksumPath.toLowerCase().startsWith("https://")) {
                    this.addJavaScriptFile(checksumPath, groupName, this.javaScriptFiles);
                } else {
                    this.addJavaScriptFile(this.resourceControllerMapping + checksumPath, groupName, this.javaScriptFiles);
                }
            }
        }
    }

    protected void addJavaScriptFile(String fileName, String groupName, LinkedHashMap<String, LinkedHashSet<String>> files) {
        LinkedHashSet<String> group = files.get(groupName);
        if (group == null) {
            group = new LinkedHashSet();
            files.put(groupName, group);
        }
        group.add(fileName);
    }

    public void addNonAmdJavaScriptFile(String fileName, String group) {
        fileName = this.normaliseDependency(fileName);
        this.addJavaScriptFile(fileName, group, this.dojoNonAmdFiles);
    }

    protected void addInlineJavaScriptForAggregation(String script, String groupName) {
        this.addJavaScriptFile(">>>" + script, groupName, this.aggJavaScriptFiles);
    }

    protected LinkedHashMap<String, LinkedHashSet<String>> filterJsDependencies(LinkedHashMap<String, LinkedHashSet<String>> files) {
        LinkedHashMap<String, LinkedHashSet<String>> filteredMap = new LinkedHashMap<String, LinkedHashSet<String>>();
        for (Map.Entry<String, LinkedHashSet<String>> group : files.entrySet()) {
            LinkedHashSet<String> filteredGroup = new LinkedHashSet<String>();
            filteredMap.put(group.getKey(), filteredGroup);
            for (String currFile : group.getValue()) {
                if (this.dependencyAlreadyRequested(currFile)) continue;
                filteredGroup.add(currFile);
                this.markDependencyAsRequested(currFile);
            }
        }
        return filteredMap;
    }

    public String flushContent() {
        for (DeferredContentSourceModelElement sourceElement : this.getSourceElements()) {
            if (!(sourceElement instanceof DependencyDeferredContentSourceModelElement)) continue;
            DependencyDeferredContentSourceModelElement dependency = (DependencyDeferredContentSourceModelElement)sourceElement;
            this.addJavaScriptFile(dependency.getDependency(), dependency.getGroup(), dependency.isAggregate());
        }
        int bufferSize = 0;
        bufferSize += 2048 * this.javaScriptFiles.size() * 3;
        bufferSize += 256 * this.aggJavaScriptFiles.size();
        StringBuilder content = new StringBuilder(bufferSize += 256 * this.dojoNonAmdFiles.size());
        if (this.javaScriptFiles.size() != 0) {
            content.append((CharSequence)this.generateJavaScriptDependencies(this.javaScriptFiles, false));
        }
        if (this.aggJavaScriptFiles.size() != 0) {
            content.append((CharSequence)this.generateJavaScriptDependencies(this.aggJavaScriptFiles, true));
        }
        if (this.dojoNonAmdFiles.size() != 0) {
            LinkedHashMap<String, LinkedHashSet<String>> filteredNonAmdFiles = this.filterJsDependencies(this.dojoNonAmdFiles);
            content.append((CharSequence)this.generateJavaScriptDependencies(filteredNonAmdFiles, true));
        }
        return content.toString();
    }

    protected StringBuilder generateJavaScriptDependencies(HashMap<String, LinkedHashSet<String>> dependencies, boolean aggregate) {
        StringBuilder jsDeps = new StringBuilder(128);
        for (Map.Entry<String, LinkedHashSet<String>> entry : dependencies.entrySet()) {
            if (aggregate) {
                String checksum = this.dependencyAggregator.generateJavaScriptDependencies(entry.getValue());
                this.appendJavaScriptDependency(jsDeps, this.resourceControllerMapping + checksum, entry.getKey());
                continue;
            }
            for (String javaScript : entry.getValue()) {
                if (javaScript == null) continue;
                if (javaScript.startsWith(">>>")) {
                    jsDeps.append("   <script type=\"text/javascript\">//<![CDATA[\n");
                    jsDeps.append(javaScript.substring(">>>".length()));
                    jsDeps.append("//]]></script>\n");
                    continue;
                }
                jsDeps.append("   <script type=\"text/javascript\" src=\"");
                jsDeps.append(javaScript);
                jsDeps.append("\"></script>");
                jsDeps.append("\n");
            }
        }
        return jsDeps;
    }

    protected void appendJavaScriptDependency(StringBuilder jsDeps, String src, String group) {
        jsDeps.append("   <script type=\"text/javascript\" src=\"");
        jsDeps.append(src);
        jsDeps.append("\"></script>");
        if (group != null) {
            jsDeps.append(" <!-- Group Name: \"");
            jsDeps.append(group);
            jsDeps.append("\" -->");
        }
        jsDeps.append("\n");
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.webFrameworkConfig;
    }

    public String getRequestPrefix() {
        return this.resourceControllerMapping;
    }

    public DependencyAggregator getDependencyAggregator() {
        return this.dependencyAggregator;
    }
}

