/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.surf.CSSCompressionHandler;
import org.springframework.extensions.surf.CssImageDataHandler;
import org.springframework.extensions.surf.CssThemeHandler;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyResource;
import org.springframework.extensions.surf.JavaScriptCompressionHandler;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.web.context.WebApplicationContext;

public class DependencyAggregator
implements ApplicationContextAware,
CacheReporter {
    private static final Log logger = LogFactory.getLog(DependencyAggregator.class);
    private Boolean isDebugMode = null;
    private Boolean isCollationDebugMode = null;
    public static final String FLAGS = "flags";
    public static final String CLIENT_DEBUG = "client-debug";
    public static final String CLIENT_COLLATION_DEBUG = "client-collation-debug";
    public static final String INLINE_AGGREGATION_MARKER = ">>>";
    public int cacheSize = 256;
    private CssImageDataHandler cssImageDataHandler;
    private CssThemeHandler cssThemeHandler;
    private DependencyHandler dependencyHandler;
    private JavaScriptCompressionHandler javaScriptCompressionHandler;
    private CSSCompressionHandler cssCompressionHandler;
    private List<String> compressionExclusions;
    private List<Pattern> compressionExclusionPatterns = new ArrayList<Pattern>();
    private ServletContext servletContext = null;
    private ScriptConfigModel scriptConfigModel;
    private List<String> missingFileWarningSuppressionList;
    private Map<Set<String>, String> fileSetToMD5Map = null;
    private Map<String, String> compressedJSResources = new HashMap<String, String>(1024);
    private Map<String, String> compressedCSSResources = new HashMap<String, String>(32);
    private Map<String, DependencyResource> combinedDependencyMap = new HashMap<String, DependencyResource>(256);
    private ReentrantReadWriteLock fileSetToMD5MapLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock compressedJSResourcesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock compressedCSSResourcesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock combinedDependencyMapLock = new ReentrantReadWriteLock();
    public static char SINGLE_QUOTE = new Character('\'').charValue();
    public static char DOUBLE_QUOTE = new Character('\"').charValue();
    public static final Pattern p = Pattern.compile("(@import[\\s\\t]*url[\\s\\t]*\\((.*?)\\))");

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setCssImageDataHandler(CssImageDataHandler cssImageDataHandler) {
        this.cssImageDataHandler = cssImageDataHandler;
    }

    public void setCssThemeHandler(CssThemeHandler cssThemeHandler) {
        this.cssThemeHandler = cssThemeHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }

    public void setJavaScriptCompressionHandler(JavaScriptCompressionHandler javaScriptCompressionHandler) {
        this.javaScriptCompressionHandler = javaScriptCompressionHandler;
    }

    public void setCssCompressionHandler(CSSCompressionHandler cssCompressionHandler) {
        this.cssCompressionHandler = cssCompressionHandler;
    }

    public void setCompressionExclusions(List<String> compressionExclusions) {
        this.compressionExclusions = compressionExclusions;
        for (String exlusion : this.compressionExclusions) {
            String regex = exlusion.replace("?", "(.?)").replace("*", "(.*)");
            this.compressionExclusionPatterns.add(Pattern.compile(regex));
        }
    }

    public boolean isDebugMode() {
        if (this.isDebugMode == null) {
            this.isDebugMode = this.getDebugFlag(CLIENT_DEBUG, Boolean.FALSE);
        }
        return this.isDebugMode;
    }

    public boolean isCollationDebugMode() {
        if (this.isCollationDebugMode == null) {
            this.isCollationDebugMode = this.getDebugFlag(CLIENT_COLLATION_DEBUG, Boolean.FALSE);
        }
        return this.isCollationDebugMode;
    }

    private Boolean getDebugFlag(String element, Boolean defaultValue) {
        ConfigElement clientDebugElement;
        Object flags;
        Boolean debugValue = defaultValue;
        Map global = this.scriptConfigModel.getGlobal();
        if (global != null && (flags = global.get(FLAGS)) instanceof GenericConfigElement && (clientDebugElement = ((GenericConfigElement)flags).getChild(element)) != null) {
            debugValue = Boolean.valueOf(clientDebugElement.getValue());
        }
        return debugValue;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    public void setScriptConfigModel(ScriptConfigModel scriptConfigModel) {
        this.scriptConfigModel = scriptConfigModel;
    }

    public List<String> getMissingFileWarningSuppressionList() {
        return this.missingFileWarningSuppressionList;
    }

    public void setMissingFileWarningSuppressionList(List<String> missingFileWarningSuppressionList) {
        this.missingFileWarningSuppressionList = missingFileWarningSuppressionList;
    }

    public String generateJavaScriptDependencies(LinkedHashSet<String> paths) {
        return this.generateDependencies(paths, CompressionType.JAVASCRIPT);
    }

    public String generateCSSDependencies(LinkedHashSet<String> paths) {
        return this.generateDependencies(paths, CompressionType.CSS);
    }

    private String generateDependencies(LinkedHashSet<String> paths, CompressionType compressionType) {
        Object checksum = this.getCachedChecksumForFileSet(paths);
        if (checksum == null) {
            String combinedDependencies;
            boolean cacheByFileSet = true;
            StringBuilder aggregatedFileContents = new StringBuilder(10240);
            for (String path : paths) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Aggregating resource path: " + (path.indexOf(10) == -1 ? path : path.substring(0, path.indexOf(10)))));
                    }
                    String fileContents = null;
                    if (path.startsWith(INLINE_AGGREGATION_MARKER)) {
                        aggregatedFileContents.append("\n/*Path=Inline insert...*/\n\n");
                        fileContents = path.substring(INLINE_AGGREGATION_MARKER.length());
                        aggregatedFileContents.append(fileContents);
                        aggregatedFileContents.append("\n\n");
                        cacheByFileSet = false;
                        continue;
                    }
                    if (this.isDebugMode() || compressionType == CompressionType.CSS) {
                        InputStream in = this.dependencyHandler.getResourceInputStream(path);
                        if (in == null) continue;
                        fileContents = this.dependencyHandler.convertResourceToString(in);
                        aggregatedFileContents.append("\n/*Path=");
                        aggregatedFileContents.append(path);
                        aggregatedFileContents.append("*/\n\n");
                        if (compressionType == CompressionType.CSS) {
                            StringBuilder sb = new StringBuilder(fileContents);
                            this.cssImageDataHandler.processCssImages(path, sb);
                            fileContents = this.processCssImports(path, sb.toString(), new HashSet<String>()).toString();
                            sb = new StringBuilder(fileContents);
                            this.adjustImageURLs(path, sb);
                            fileContents = sb.toString();
                        }
                        aggregatedFileContents.append(fileContents);
                        aggregatedFileContents.append("\n");
                        continue;
                    }
                    fileContents = this.getCompressedFile(path, compressionType);
                    if (fileContents == null) {
                        logger.error((Object)("Could not retrieve path:" + path));
                        continue;
                    }
                    aggregatedFileContents.append(fileContents);
                }
                catch (IOException e) {
                    logger.error((Object)("An exception occurred compressing: " + path));
                }
            }
            if (compressionType == CompressionType.CSS) {
                try {
                    combinedDependencies = this.cssThemeHandler.processCssThemes("", aggregatedFileContents);
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to process themes: " + e.getMessage()));
                    combinedDependencies = aggregatedFileContents.toString();
                }
            } else {
                combinedDependencies = aggregatedFileContents.toString();
            }
            checksum = this.dependencyHandler.generateCheckSum(combinedDependencies) + compressionType.fileExtension;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checksum for aggregated dependencies: " + (String)checksum));
            }
            DependencyResource resource = new DependencyResource(compressionType.mimetype, combinedDependencies, this.dependencyHandler.getCharset());
            this.cacheDependencyResource((String)checksum, resource);
            if (cacheByFileSet && !this.isDebugMode()) {
                this.cacheChecksumForFileSet(paths, (String)checksum);
            }
        }
        return checksum;
    }

    public String getCachedChecksumForFileSet(Set<String> fileSet) {
        String themeId = ThreadLocalRequestContext.getRequestContext().getThemeId();
        fileSet.add(themeId);
        String checksum = this.getFileSetChecksumCache().get(fileSet);
        fileSet.remove(themeId);
        return checksum;
    }

    protected void cacheChecksumForFileSet(Set<String> fileSet, String checksum) {
        String themeId = ThreadLocalRequestContext.getRequestContext().getThemeId();
        fileSet.add(themeId);
        this.getFileSetChecksumCache().put(fileSet, checksum);
    }

    protected Map<Set<String>, String> getFileSetChecksumCache() {
        if (this.fileSetToMD5Map == null) {
            this.fileSetToMD5MapLock.writeLock().lock();
            try {
                if (this.fileSetToMD5Map == null) {
                    this.fileSetToMD5Map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.cacheSize).concurrencyLevel(16).weigher(Weighers.singleton()).listener((EvictionListener)new EvictionListener<Set<String>, String>(){

                        public void onEviction(Set<String> key, String value) {
                            DependencyAggregator.this.combinedDependencyMapLock.writeLock().lock();
                            try {
                                DependencyAggregator.this.combinedDependencyMap.remove(value);
                            }
                            finally {
                                DependencyAggregator.this.combinedDependencyMapLock.writeLock().unlock();
                            }
                        }
                    }).build();
                }
            }
            finally {
                this.fileSetToMD5MapLock.writeLock().unlock();
            }
        }
        return this.fileSetToMD5Map;
    }

    public String getCachedCompressedJSResource(String path) {
        String checksum = null;
        this.compressedJSResourcesLock.readLock().lock();
        try {
            checksum = this.compressedJSResources.get(path);
        }
        finally {
            this.compressedJSResourcesLock.readLock().unlock();
        }
        return checksum;
    }

    protected void cacheCompressedJSResource(String path, String content) {
        this.compressedJSResourcesLock.writeLock().lock();
        try {
            this.compressedJSResources.put(path, content);
        }
        finally {
            this.compressedJSResourcesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedCompressedCssResource(String path) {
        String content = null;
        String prefix = ThreadLocalRequestContext.getRequestContext().getThemeId();
        this.compressedCSSResourcesLock.readLock().lock();
        try {
            content = this.compressedCSSResources.get(prefix + path);
        }
        finally {
            this.compressedCSSResourcesLock.readLock().unlock();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCompressedCssResource(String path, String content) {
        String prefix = ThreadLocalRequestContext.getRequestContext().getThemeId();
        this.compressedCSSResourcesLock.writeLock().lock();
        try {
            this.compressedCSSResources.put(prefix + path, content);
        }
        finally {
            this.compressedCSSResourcesLock.writeLock().unlock();
        }
    }

    public DependencyResource getCachedDependencyResource(String checksum) {
        this.combinedDependencyMapLock.readLock().lock();
        try {
            DependencyResource dependencyResource = this.combinedDependencyMap.get(checksum);
            return dependencyResource;
        }
        finally {
            this.combinedDependencyMapLock.readLock().unlock();
        }
    }

    protected void cacheDependencyResource(String checksum, DependencyResource content) {
        this.combinedDependencyMapLock.writeLock().lock();
        try {
            this.combinedDependencyMap.put(checksum, content);
        }
        finally {
            this.combinedDependencyMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        this.fileSetToMD5MapLock.writeLock().lock();
        try {
            this.fileSetToMD5Map = null;
        }
        finally {
            this.fileSetToMD5MapLock.writeLock().unlock();
        }
        this.compressedJSResourcesLock.writeLock().lock();
        try {
            this.compressedJSResources.clear();
        }
        finally {
            this.compressedJSResourcesLock.writeLock().unlock();
        }
        this.compressedCSSResourcesLock.writeLock().lock();
        try {
            this.compressedCSSResources.clear();
        }
        finally {
            this.compressedCSSResourcesLock.writeLock().unlock();
        }
        this.combinedDependencyMapLock.writeLock().lock();
        try {
            this.combinedDependencyMap.clear();
        }
        finally {
            this.combinedDependencyMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(4);
        long size = 0L;
        if (this.fileSetToMD5Map != null) {
            this.fileSetToMD5MapLock.writeLock().lock();
            try {
                for (Set set : this.fileSetToMD5Map.keySet()) {
                    for (String p : set) {
                        size += (long)(p.length() * 2);
                    }
                    size += 64L;
                }
                reports.add(new CacheReport("fileSetToMD5Map", this.fileSetToMD5Map.size(), size));
            }
            finally {
                this.fileSetToMD5MapLock.writeLock().unlock();
            }
        }
        size = 0L;
        this.compressedJSResourcesLock.writeLock().lock();
        try {
            for (String string : this.compressedJSResources.values()) {
                size += (long)(string.length() * 2 + 64);
            }
            reports.add(new CacheReport("compressedJSResources", this.compressedJSResources.size(), size));
        }
        finally {
            this.compressedJSResourcesLock.writeLock().unlock();
        }
        size = 0L;
        this.compressedCSSResourcesLock.writeLock().lock();
        try {
            for (String string : this.compressedCSSResources.values()) {
                size += (long)(string.length() * 2);
            }
            reports.add(new CacheReport("compressedCSSResources", this.compressedCSSResources.size(), size));
        }
        finally {
            this.compressedCSSResourcesLock.writeLock().unlock();
        }
        size = 0L;
        this.combinedDependencyMapLock.writeLock().lock();
        try {
            for (DependencyResource dependencyResource : this.combinedDependencyMap.values()) {
                size += (long)dependencyResource.getStoredSize();
            }
            reports.add(new CacheReport("combinedDependencyMap", this.combinedDependencyMap.size(), size));
        }
        finally {
            this.combinedDependencyMapLock.writeLock().unlock();
        }
        return reports;
    }

    public void adjustImageURLs(String cssPath, StringBuilder cssContents) throws IOException {
        String pathPrefix = "";
        int lastForwardSlash = cssPath.lastIndexOf("/");
        if (lastForwardSlash != -1) {
            pathPrefix = cssPath.substring(0, lastForwardSlash);
        }
        int index = cssContents.indexOf("url(");
        while (index != -1) {
            int matchingClose = cssContents.indexOf(")", index + "url(".length());
            if (matchingClose == -1) {
                return;
            }
            Object imageSrc = cssContents.substring(index + "url(".length(), matchingClose).trim();
            if (((String)imageSrc).startsWith("\"") || ((String)imageSrc).startsWith("'")) {
                imageSrc = ((String)imageSrc).substring(1);
            }
            if (((String)imageSrc).endsWith("\"") || ((String)imageSrc).endsWith("'")) {
                imageSrc = ((String)imageSrc).substring(0, ((String)imageSrc).length() - 1);
            }
            if (((String)imageSrc).startsWith("data:image/") || ((String)imageSrc).toLowerCase().startsWith("http://") || ((String)imageSrc).startsWith("/")) {
                index = cssContents.indexOf("url(", matchingClose);
                continue;
            }
            if (((String)imageSrc).startsWith(".") && !((String)imageSrc).startsWith("..")) {
                imageSrc = ((String)imageSrc).substring(1);
                imageSrc = pathPrefix + (String)imageSrc;
            } else if (!((String)imageSrc).startsWith("..")) {
                imageSrc = pathPrefix + "/" + (String)imageSrc;
            } else {
                String tmp = pathPrefix;
                while (((String)imageSrc).startsWith("..")) {
                    imageSrc = ((String)imageSrc).substring(3);
                    int lastSlashIndex = tmp.lastIndexOf("/");
                    if (lastSlashIndex != -1) {
                        tmp = tmp.substring(0, lastSlashIndex);
                        continue;
                    }
                    tmp = "";
                }
                imageSrc = !tmp.endsWith("/") && !((String)imageSrc).startsWith("/") ? tmp + "/" + (String)imageSrc : tmp + (String)imageSrc;
            }
            if (((String)imageSrc).startsWith("/")) {
                imageSrc = ((String)imageSrc).substring(1);
            }
            String prefix = this.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
            imageSrc = prefix + (String)imageSrc;
            int offset = index + "url(".length();
            cssContents.delete(offset, matchingClose);
            offset = this.cssImageDataHandler.insert(cssContents, offset, (String)imageSrc);
            index = cssContents.indexOf("url(", offset);
        }
    }

    public StringBuffer processCssImports(String cssPath, String fileContents, Set<String> processedPaths) {
        StringBuffer s = new StringBuffer(1024);
        if (fileContents != null) {
            Matcher m = p.matcher(fileContents);
            while (m.find()) {
                char lastChar;
                if (m.group(2) == null) continue;
                StringBuilder path = new StringBuilder(m.group(2).trim());
                if (path.charAt(0) == SINGLE_QUOTE || path.charAt(0) == DOUBLE_QUOTE) {
                    path.deleteCharAt(0);
                }
                if ((lastChar = path.charAt(path.length() - 1)) == SINGLE_QUOTE || lastChar == DOUBLE_QUOTE) {
                    path.deleteCharAt(path.length() - 1);
                }
                String importContents = null;
                try {
                    String importPath = this.dependencyHandler.getRelativePath(cssPath, path.toString());
                    importContents = this.getCompressedFile(importPath, CompressionType.CSS);
                    importContents = this.processCssImport(importContents, cssPath, importPath, processedPaths);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (importContents == null) continue;
                m.appendReplacement(s, importContents);
            }
            m.appendTail(s);
        }
        return s;
    }

    protected String processCssImport(String importContents, String cssPath, String importPath, Set<String> processedPaths) throws IOException {
        StringBuilder s1 = new StringBuilder();
        if (importPath.equals(cssPath) || processedPaths.contains(importPath)) {
            s1.append(importContents);
        } else {
            processedPaths.add(importPath);
            s1.append(this.processCssImports(importPath, importContents, processedPaths));
        }
        this.adjustImageURLs(importPath, s1);
        importContents = s1.toString();
        return importContents;
    }

    String getCompressedFile(String path, CompressionType type) throws IOException {
        String compressedFile;
        block22: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Compressing " + path + " as " + String.valueOf((Object)type)));
            }
            compressedFile = null;
            if (type == CompressionType.JAVASCRIPT) {
                compressedFile = this.getCachedCompressedJSResource(path);
            } else if (type == CompressionType.CSS) {
                compressedFile = this.getCachedCompressedCssResource(path);
            }
            if (compressedFile == null || this.isDebugMode()) {
                if (this.excludeFileFromCompression(path)) {
                    InputStream in = this.dependencyHandler.getResourceInputStream(path);
                    if (in != null) {
                        compressedFile = this.dependencyHandler.convertResourceToString(in);
                        if (type == CompressionType.JAVASCRIPT) {
                            this.cacheCompressedJSResource(path, compressedFile);
                        } else if (type == CompressionType.CSS) {
                            this.cacheCompressedCssResource(path, compressedFile);
                        }
                    }
                } else {
                    InputStream in = this.dependencyHandler.getResourceInputStream(path);
                    if (in == null) {
                        boolean outputError = true;
                        for (String pathToSuppress : this.missingFileWarningSuppressionList) {
                            if (!path.matches(pathToSuppress)) continue;
                            outputError = false;
                            break;
                        }
                        if (outputError && logger.isErrorEnabled()) {
                            logger.error((Object)("Could not find compressed file: " + path));
                        }
                    } else {
                        try {
                            if (type == CompressionType.JAVASCRIPT) {
                                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                                compressedFile = this.compressJavaScript(reader);
                                this.cacheCompressedJSResource(path, compressedFile);
                            } else if (type == CompressionType.CSS) {
                                compressedFile = this.compressCSSFile(in);
                                this.cacheCompressedCssResource(path, compressedFile);
                            }
                        }
                        catch (IOException e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("The file: \"" + path + "\" could not be compressed due to the following error: "), (Throwable)e);
                            }
                            compressedFile = IOUtils.toString((InputStream)in, (String)"UTF-8");
                            if (type == CompressionType.JAVASCRIPT) {
                                this.cacheCompressedJSResource(path, compressedFile);
                            }
                            if (type != CompressionType.CSS) break block22;
                            this.cacheCompressedCssResource(path, compressedFile);
                        }
                    }
                }
            }
        }
        return compressedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressJavaScript(Reader reader) throws IOException {
        String compressedFile = null;
        StringWriter out = new StringWriter();
        if (this.isCollationDebugMode()) {
            try {
                char[] buffer = new char[1024];
                try {
                    int n;
                    while ((n = reader.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Compression error: ", (Throwable)e);
            }
        } else {
            this.javaScriptCompressionHandler.compress(reader, out);
        }
        compressedFile = out.toString();
        return compressedFile;
    }

    public String compressCSSFile(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        StringWriter out = new StringWriter();
        this.cssCompressionHandler.compress(reader, out);
        String compressedFile = out.toString();
        return compressedFile;
    }

    public boolean excludeFileFromCompression(String path) {
        boolean exclude = false;
        for (Pattern p : this.compressionExclusionPatterns) {
            Matcher m = p.matcher(path);
            if (!m.matches()) continue;
            exclude = true;
            break;
        }
        return exclude;
    }

    public static enum CompressionType {
        JAVASCRIPT("text/javascript", ".js"),
        CSS("text/css", ".css");

        private final String mimetype;
        private final String fileExtension;

        private CompressionType(String mimetype, String fileExtension) {
            this.mimetype = mimetype;
            this.fileExtension = fileExtension;
        }
    }
}

