/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.surf.CssImageDataHandler;
import org.springframework.extensions.surf.CssThemeHandler;
import org.springframework.extensions.surf.DependencyHandlerProcessingCallback;
import org.springframework.extensions.surf.RemoteResourcesHandler;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;

public class DependencyHandler
implements ApplicationContextAware,
CacheReporter {
    public static final String CSS = ".css";
    private static final Log logger = LogFactory.getLog(DependencyHandler.class);
    private String charset;
    private String digest;
    private ApplicationContext applicationContext = null;
    private ServletContext servletContext = null;
    private ScriptConfigModel scriptConfigModel;
    private CssImageDataHandler cssDataImageHandler;
    private CssThemeHandler cssThemeHandler;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private String resourceControllerMapping = "";
    private RemoteResourcesHandler remoteResourcesHandler;
    private final Map<String, String> cachedChecksumPaths = new HashMap<String, String>(1024);
    private final Map<String, String> cachedChecksums = new HashMap<String, String>(1024);
    private final ReadWriteLock checksumPathsLock = new ReentrantReadWriteLock();
    private final ReadWriteLock checksumsLock = new ReentrantReadWriteLock();
    private Boolean isDebugMode = null;
    public static final String FLAGS = "flags";
    public static final String CLIENT_DEBUG = "client-debug";
    private List<String> debugSuffices;
    private List<String> productionSuffices;
    private final Map<String, ResourceInfo> cachedResourceInfoMap = new HashMap<String, ResourceInfo>(2048);
    private final ReadWriteLock resourceInfoLock = new ReentrantReadWriteLock();
    private static final String[] hex = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    private static ResourceInfoSentinel RESOURCE_INFO_SENTINEL = null;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setScriptConfigModel(ScriptConfigModel scriptConfigModel) {
        this.scriptConfigModel = scriptConfigModel;
    }

    public void setCssDataImageHandler(CssImageDataHandler cssDataImageHandler) {
        this.cssDataImageHandler = cssDataImageHandler;
    }

    public CssImageDataHandler getCssDataImageHandler() {
        return this.cssDataImageHandler;
    }

    public void setCssThemeHandler(CssThemeHandler cssThemeHandler) {
        this.cssThemeHandler = cssThemeHandler;
    }

    public CssThemeHandler getCssThemeHandler() {
        return this.cssThemeHandler;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public WebFrameworkConfigElement getWebFrameworkConfigElement() {
        return this.webFrameworkConfigElement;
    }

    public String getResourceControllerMapping() {
        return this.resourceControllerMapping;
    }

    public void setResourceControllerMapping(String resourceControllerMapping) {
        this.resourceControllerMapping = resourceControllerMapping;
    }

    public RemoteResourcesHandler getRemoteResourcesHandler() {
        return this.remoteResourcesHandler;
    }

    public void setRemoteResourcesHandler(RemoteResourcesHandler remoteResourcesHandler) {
        this.remoteResourcesHandler = remoteResourcesHandler;
    }

    public boolean isDebugMode() {
        if (this.isDebugMode == null) {
            this.isDebugMode = this.getDebugFlag(CLIENT_DEBUG, Boolean.FALSE);
        }
        return this.isDebugMode;
    }

    private Boolean getDebugFlag(String element, Boolean defaultValue) {
        ConfigElement clientDebugElement;
        Object flags;
        Boolean debugValue = defaultValue;
        Map global = this.scriptConfigModel.getGlobal();
        if (global != null && (flags = global.get(FLAGS)) instanceof GenericConfigElement && (clientDebugElement = ((GenericConfigElement)flags).getChild(element)) != null) {
            debugValue = Boolean.valueOf(clientDebugElement.getValue());
        }
        return debugValue;
    }

    public void setDebugSuffices(List<String> debugSuffices) {
        this.debugSuffices = debugSuffices;
    }

    public void setProductionSuffices(List<String> productionSuffices) {
        this.productionSuffices = productionSuffices;
    }

    public List<String> generatePathsForClientMode(String path) {
        List<String> paths = null;
        if (this.isDebugMode() && this.debugSuffices != null) {
            paths = this.generatePathForSuffices(path, this.debugSuffices);
        } else if (!this.isDebugMode() && this.productionSuffices != null) {
            paths = this.generatePathForSuffices(path, this.productionSuffices);
        }
        if (paths == null) {
            paths = new ArrayList<String>(1);
            paths.add(path);
        }
        return paths;
    }

    private List<String> generatePathForSuffices(String path, List<String> suffices) {
        ArrayList<CallSite> paths = null;
        int lastDotIndex = path.lastIndexOf(".");
        if (lastDotIndex != -1) {
            paths = new ArrayList<CallSite>(suffices.size());
            for (String suffix : suffices) {
                String generatedPath = path.substring(0, lastDotIndex) + suffix + path.substring(lastDotIndex);
                paths.add((CallSite)((Object)generatedPath));
            }
        }
        return paths;
    }

    protected ResourceInfo getCachedResourceInfo(String path) {
        ResourceInfo resource = null;
        this.resourceInfoLock.readLock().lock();
        try {
            resource = this.cachedResourceInfoMap.get(path);
        }
        finally {
            this.resourceInfoLock.readLock().unlock();
        }
        return resource;
    }

    public boolean resourceInCache(String path) {
        ResourceInfo resource = this.getCachedResourceInfo(path);
        return resource != null && resource != this.getResourceInfoSentinel();
    }

    public InputStream getResourceInputStream(String path) throws IOException {
        return this.getResourceInputStream(path, null);
    }

    public InputStream getResourceInputStream(String path, DependencyHandlerProcessingCallback callback) throws IOException {
        InputStream in = null;
        ResourceInfo resourceInfo = this.getCachedResourceInfo(path);
        if (resourceInfo != this.getResourceInfoSentinel()) {
            if (!(resourceInfo == null || this.isDebugMode() && callback != null)) {
                in = resourceInfo.getInputStream();
            } else {
                String currPath;
                Iterator<String> paths;
                List<String> pathsToCheck = this.generatePathsForClientMode(path);
                if (this.webFrameworkConfigElement.isRemoteResourceResolvingEnabled()) {
                    paths = pathsToCheck.iterator();
                    while (in == null && paths.hasNext()) {
                        currPath = paths.next();
                        in = this.remoteResourcesHandler.getRemoteResource(currPath);
                        if (in == null) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found REMOTE resource: " + currPath));
                        }
                        this.addResourceInfoToCache(path, new RemoteResource(currPath), callback);
                        in = this.getCachedResourceInfo(path).getInputStream();
                    }
                }
                paths = pathsToCheck.iterator();
                while (in == null && paths.hasNext()) {
                    currPath = paths.next();
                    Resource r = this.applicationContext.getResource("classpath*:" + currPath);
                    if (r == null || !r.exists()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found CLASSPATH resource: " + currPath));
                    }
                    this.addResourceInfoToCache(path, new ApplicationContextResource(currPath), callback);
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
                paths = pathsToCheck.iterator();
                while (in == null && paths.hasNext()) {
                    URL resourceUrl;
                    currPath = paths.next();
                    if (currPath.startsWith("/")) {
                        currPath = currPath.substring(1);
                    }
                    if ((resourceUrl = ClassUtils.getDefaultClassLoader().getResource("META-INF/" + currPath)) == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found JAR resource: " + currPath));
                    }
                    this.addResourceInfoToCache(path, new ClassLoaderResource(currPath), callback);
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
                paths = pathsToCheck.iterator();
                while (this.servletContext != null && in == null && paths.hasNext()) {
                    ServletContextResource resource;
                    String p = paths.next();
                    if (StringUtils.cleanPath((String)p).startsWith("..") || !(resource = new ServletContextResource(this.servletContext, p)).exists()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found SERVLET resource: " + p));
                    }
                    this.addResourceInfoToCache(path, new ServletContextRes(p), callback);
                    in = this.getCachedResourceInfo(path).getInputStream();
                }
            }
        }
        if (in == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("FAILED to find resource: " + path));
            }
            this.addResourceInfoToCache(path, this.getResourceInfoSentinel(), callback);
        }
        return in;
    }

    public static String generateCheckSumPath(String path, String checksum) {
        int lastDotIndex;
        Object checksumPath = checksum != null && checksum.length() == 0 ? path : ((lastDotIndex = path.lastIndexOf(46)) != -1 ? path.substring(0, lastDotIndex) + "_" + checksum + path.substring(lastDotIndex) : path + "_" + checksum);
        return checksumPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceInfoToCache(String path, ResourceInfo resourceInfo, DependencyHandlerProcessingCallback callback) throws IOException {
        String checksum = "";
        if (resourceInfo != this.getResourceInfoSentinel() && ((checksum = this.lookupChecksumInCache(path)) == null || this.isDebugMode())) {
            InputStream in = resourceInfo.getInputStream();
            if (in != null) {
                String resourceContents = this.convertResourceToString(in);
                if (callback != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Executing callback for resource: " + path));
                    }
                    resourceContents = callback.process(this, path, resourceContents);
                    resourceInfo.setContents(resourceContents);
                }
                checksum = this.generateCheckSum(resourceContents);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Calculating resource checksum and adding to cache: " + path + " = " + checksum));
            }
            this.addChecksumToCache(path, checksum);
        }
        String checksumPath = DependencyHandler.generateCheckSumPath(path, checksum);
        this.addChecksumPathToCache(path, checksumPath);
        this.resourceInfoLock.writeLock().lock();
        try {
            this.cachedResourceInfoMap.put(path, resourceInfo);
            this.cachedResourceInfoMap.put(checksumPath, resourceInfo);
        }
        finally {
            this.resourceInfoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertResourceToString(InputStream in) throws IOException {
        String s = null;
        if (in != null) {
            StringBuilderWriter writer = new StringBuilderWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.charset));
                while ((n = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, n);
                }
                s = writer.toString();
            }
            finally {
                in.close();
            }
        }
        return s;
    }

    public String getChecksumPath(String path) {
        String checksumPath = this.lookupChecksumPathInCache(path);
        if (checksumPath == null) {
            try {
                this.getResourceInputStream(path);
                checksumPath = this.lookupChecksumPathInCache(path);
            }
            catch (IOException e) {
                logger.error((Object)"The following error occurred attempting to obtain a checksum path", (Throwable)e);
            }
        }
        return checksumPath;
    }

    public String getChecksum(String path, DependencyHandlerProcessingCallback callback) {
        String checksum = this.lookupChecksumInCache(path);
        if (checksum == null || this.isDebugMode()) {
            try {
                this.getResourceInputStream(path, callback);
                checksum = this.lookupChecksumInCache(path);
            }
            catch (IOException e) {
                logger.error((Object)"The following error occurred attempting to obtain a checksum path", (Throwable)e);
            }
        }
        return checksum;
    }

    protected String lookupChecksumPathInCache(String path) {
        String checksumPath = null;
        this.checksumPathsLock.readLock().lock();
        try {
            checksumPath = this.cachedChecksumPaths.get(path);
        }
        finally {
            this.checksumPathsLock.readLock().unlock();
        }
        return checksumPath;
    }

    protected String lookupChecksumInCache(String path) {
        String checksumPath = null;
        this.checksumsLock.readLock().lock();
        try {
            checksumPath = this.cachedChecksums.get(path);
        }
        finally {
            this.checksumsLock.readLock().unlock();
        }
        return checksumPath;
    }

    protected void addChecksumPathToCache(String path, String checksumPath) {
        this.checksumPathsLock.writeLock().lock();
        try {
            this.cachedChecksumPaths.put(path, checksumPath);
        }
        finally {
            this.checksumPathsLock.writeLock().unlock();
        }
    }

    protected void addChecksumToCache(String path, String checksum) {
        this.checksumsLock.writeLock().lock();
        try {
            this.cachedChecksums.put(path, checksum);
        }
        finally {
            this.checksumsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearCaches() {
        this.checksumsLock.writeLock().lock();
        try {
            this.cachedChecksums.clear();
        }
        finally {
            this.checksumsLock.writeLock().unlock();
        }
        this.resourceInfoLock.writeLock().lock();
        try {
            this.cachedResourceInfoMap.clear();
        }
        finally {
            this.resourceInfoLock.writeLock().unlock();
        }
        this.checksumPathsLock.writeLock().lock();
        try {
            this.cachedChecksumPaths.clear();
        }
        finally {
            this.checksumPathsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(3);
        long size = 0L;
        this.checksumsLock.writeLock().lock();
        try {
            for (String string : this.cachedChecksums.keySet()) {
                size += (long)(string.length() * 2 + 64);
            }
            reports.add(new CacheReport("cachedChecksums", this.cachedChecksums.size(), size));
        }
        finally {
            this.checksumsLock.writeLock().unlock();
        }
        size = 0L;
        this.resourceInfoLock.writeLock().lock();
        try {
            for (ResourceInfo resourceInfo : this.cachedResourceInfoMap.values()) {
                if (resourceInfo.path != null) {
                    size += (long)(resourceInfo.path.length() * 2);
                    size += resourceInfo.getContents() != null ? (long)(resourceInfo.getContents().length() * 2) : 32L;
                    continue;
                }
                size += 16L;
            }
            reports.add(new CacheReport("cachedResourceInfoMap", this.cachedResourceInfoMap.size(), size));
        }
        finally {
            this.resourceInfoLock.writeLock().unlock();
        }
        size = 0L;
        this.checksumPathsLock.writeLock().lock();
        try {
            for (String string : this.cachedChecksumPaths.values()) {
                size += (long)(string.length() * 2);
            }
            reports.add(new CacheReport("cachedChecksumPaths", this.cachedChecksumPaths.size(), size));
        }
        finally {
            this.checksumPathsLock.writeLock().unlock();
        }
        return reports;
    }

    public String generateCheckSum(String source) {
        StringBuilder checksum = new StringBuilder(32);
        try {
            byte[] checksumInBytes;
            byte[] compressedFileInBytes = source.getBytes(this.charset);
            MessageDigest md = MessageDigest.getInstance(this.digest);
            md.reset();
            for (byte b : checksumInBytes = md.digest(compressedFileInBytes)) {
                checksum.append(hex[0xFF & b]);
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"Could not find MD5 algorithm for generating checksum", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Unsupported encoding", (Throwable)e);
        }
        return checksum.toString();
    }

    public String getRelativePath(String sourcePath, String targetPath) {
        int lastForwardSlashIndex;
        StringBuilder sb = new StringBuilder(64);
        String pathPrefix = "";
        if (sourcePath != null && (lastForwardSlashIndex = sourcePath.lastIndexOf("/")) != -1) {
            pathPrefix = sourcePath.substring(0, lastForwardSlashIndex);
        }
        if (targetPath.startsWith("\"") || targetPath.startsWith("'")) {
            targetPath = targetPath.substring(1);
        }
        if (targetPath.endsWith("\"") || targetPath.endsWith("'")) {
            targetPath = targetPath.substring(0, targetPath.length() - 1);
        }
        if (targetPath.startsWith(".") && !targetPath.startsWith("..")) {
            targetPath = targetPath.substring(2);
        }
        while (targetPath.startsWith("../")) {
            int idx = pathPrefix.lastIndexOf("/");
            if (idx != -1) {
                pathPrefix = pathPrefix.substring(0, idx);
                targetPath = targetPath.substring(3);
                continue;
            }
            if (pathPrefix.length() <= 0) break;
            pathPrefix = "";
            targetPath = targetPath.substring(3);
        }
        if (!(targetPath.startsWith("/") || targetPath.toLowerCase().startsWith("http://") || targetPath.toLowerCase().startsWith("https://"))) {
            sb.append(pathPrefix);
            sb.append("/");
        }
        sb.append(targetPath);
        return sb.toString();
    }

    private ResourceInfoSentinel getResourceInfoSentinel() {
        if (RESOURCE_INFO_SENTINEL == null) {
            RESOURCE_INFO_SENTINEL = new ResourceInfoSentinel();
        }
        return RESOURCE_INFO_SENTINEL;
    }

    protected abstract class ResourceInfo {
        protected final String path;
        private String contents;

        protected ResourceInfo(String path) {
            this.path = path;
        }

        public String getContents() {
            return this.contents;
        }

        private void setContents(String contents) {
            this.contents = contents;
        }

        public InputStream getInputStream() throws IOException {
            InputStream in = null;
            in = this.contents == null ? this.loadInputStream() : new ByteArrayInputStream(this.contents.getBytes(DependencyHandler.this.charset));
            return in;
        }

        public abstract InputStream loadInputStream() throws IOException;
    }

    private class ResourceInfoSentinel
    extends ResourceInfo {
        private ResourceInfoSentinel() {
            super(null);
        }

        @Override
        public InputStream loadInputStream() throws IOException {
            return null;
        }
    }

    private class RemoteResource
    extends ResourceInfo {
        private RemoteResource(String path) {
            super(path);
        }

        @Override
        public InputStream loadInputStream() throws IOException {
            InputStream in = DependencyHandler.this.remoteResourcesHandler.getRemoteResource(this.path);
            return in;
        }
    }

    private class ApplicationContextResource
    extends ResourceInfo {
        private ApplicationContextResource(String path) {
            super(path);
        }

        @Override
        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            Resource r = DependencyHandler.this.applicationContext.getResource("classpath*:" + this.path);
            if (r != null && r.exists()) {
                in = r.getInputStream();
            }
            return in;
        }
    }

    private class ClassLoaderResource
    extends ResourceInfo {
        private ClassLoaderResource(String path) {
            super(path);
        }

        @Override
        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            URL resourceUrl = ClassUtils.getDefaultClassLoader().getResource("META-INF/" + this.path);
            if (resourceUrl != null) {
                in = resourceUrl.openStream();
            }
            return in;
        }
    }

    private class ServletContextRes
    extends ResourceInfo {
        private ServletContextRes(String path) {
            super(path);
        }

        @Override
        public InputStream loadInputStream() throws IOException {
            InputStream in = null;
            ServletContextResource resource = new ServletContextResource(DependencyHandler.this.servletContext, this.path);
            if (resource.exists()) {
                in = resource.getInputStream();
            }
            return in;
        }
    }
}

