/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.JavaScriptCompressionHandler;

public class ExternalJavaScriptCompressionHandler
implements JavaScriptCompressionHandler {
    private static final Log logger = LogFactory.getLog(ExternalJavaScriptCompressionHandler.class);
    private String cmd;

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(Reader reader, Writer writer) throws IOException {
        if (this.cmd == null || this.cmd.length() == 0) {
            throw new IllegalArgumentException("External compressor 'cmd' not set correctly in bean config.");
        }
        Process proc = Runtime.getRuntime().exec(this.cmd);
        BufferedWriter stdIn = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
        BufferedReader stdOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            String s;
            IOUtils.copy((Reader)reader, (Writer)stdIn);
            stdIn.close();
            while ((s = stdOut.readLine()) != null) {
                writer.append(s);
            }
            stdOut.close();
            s = stdError.readLine();
            if (s != null) {
                StringBuilder buf = new StringBuilder("Error during external JavaScript compilation:\r\n");
                do {
                    buf.append(s);
                } while ((s = stdError.readLine()) != null);
                stdError.close();
                throw new IOException(buf.toString());
            }
        }
        finally {
            stdError.close();
            stdOut.close();
            stdIn.close();
        }
    }
}

