/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.site;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RequestUtil {
    public static void include(HttpServletRequest request, HttpServletResponse response, String dispatchPath) throws ServletException, IOException {
        request.getRequestDispatcher(dispatchPath).include((ServletRequest)request, (ServletResponse)response);
    }

    public static void include(ServletContext context, ServletRequest request, ServletResponse response, String dispatchPath) throws ServletException, IOException {
        RequestDispatcher disp = context.getRequestDispatcher(dispatchPath);
        disp.include(request, response);
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response, String dispatchPath) throws ServletException {
        try {
            request.getRequestDispatcher(dispatchPath).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public static void forward(ServletContext context, ServletRequest request, ServletResponse response, String dispatchPath) throws ServletException {
        try {
            RequestDispatcher disp = context.getRequestDispatcher(dispatchPath);
            disp.forward(request, response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

