/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.Serializable;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;

public abstract class TagBase
extends BodyTagSupport
implements Serializable {
    private static final long serialVersionUID = -387841473754510763L;
    private PageContext pageContext = null;

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    protected PageContext getPageContext() {
        return this.pageContext;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    protected RequestContext getRequestContext() throws JspException {
        return ThreadLocalRequestContext.getRequestContext();
    }

    protected RequestContext getRenderContext() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        return (RequestContext)request.getAttribute("renderContext");
    }

    protected ModelObject getModelObject() {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        return (ModelObject)request.getAttribute("modelObject");
    }

    protected RenderService getRenderService() {
        return ThreadLocalRequestContext.getRequestContext().getServiceRegistry().getRenderService();
    }

    protected JspWriter getOut() {
        return this.getPageContext().getOut();
    }

    protected void print(String str) throws JspException {
        try {
            JspWriter jspWriter = this.getOut();
            jspWriter.clearBuffer();
            jspWriter.print(str);
        }
        catch (Exception ex) {
            throw new JspException((Throwable)ex);
        }
    }

    public void release() {
        this.pageContext = null;
        super.release();
    }
}

