/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Theme;

public class ThemeImpl
extends AbstractModelObject
implements Theme {
    private static final long serialVersionUID = -5592730666596308336L;
    private final Map<String, String> pageTypeCache = new ConcurrentHashMap<String, String>();
    private Map<String, String> cssTokens = new HashMap<String, String>();
    private static final String _PAGE_TYPES_ELEMENT = "page-types";
    private static final String _PAGE_TYPE_ELEMENT = "page-type";
    private static final String _ID_ELEMENT = "id";
    private static final String _PAGE_INSTANCE_ID_ELEMENT = "page-instance-id";
    private static final String _PAGE_ID_ELEMENT = "page-id";
    private static final String SENTINEL_MAPPED_PAGE_ID = "<null>";

    @Override
    public Map<String, String> getCssTokens() {
        return this.cssTokens;
    }

    public ThemeImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        List cssTokenMaps = this.getDocument().getRootElement().elements("css-tokens");
        if (cssTokenMaps != null) {
            for (Element cssTokenMapEl : cssTokenMaps) {
                List cssTokenEls = cssTokenMapEl.elements();
                for (Element cssTokenEl : cssTokenEls) {
                    String subValue = cssTokenEl.getStringValue();
                    if (subValue == null) {
                        subValue = "";
                    }
                    this.cssTokens.put(cssTokenEl.getName(), subValue.trim());
                }
            }
        }
    }

    @Override
    public String getTypeId() {
        return "theme";
    }

    @Override
    public String getPageId(String pageTypeId) {
        String mappedPageId = this.pageTypeCache.get(pageTypeId);
        if (mappedPageId == null) {
            Element pageTypesEl = this.getDocument().getRootElement().element(_PAGE_TYPES_ELEMENT);
            if (pageTypesEl != null) {
                List pageTypes = pageTypesEl.elements(_PAGE_TYPE_ELEMENT);
                for (int i = 0; i < pageTypes.size(); ++i) {
                    Element pageType = (Element)pageTypes.get(i);
                    String id = pageType.elementText(_ID_ELEMENT);
                    if (id == null || !id.equals(pageTypeId) || (mappedPageId = pageType.elementText(_PAGE_INSTANCE_ID_ELEMENT)) != null) continue;
                    mappedPageId = pageType.elementText(_PAGE_ID_ELEMENT);
                }
            }
            this.pageTypeCache.put(pageTypeId, mappedPageId != null ? mappedPageId : SENTINEL_MAPPED_PAGE_ID);
        }
        return mappedPageId != SENTINEL_MAPPED_PAGE_ID ? mappedPageId : null;
    }

    @Override
    public void setDefaultPageId(String pageTypeId, String pageId) {
        this.pageTypeCache.put(pageTypeId, pageId);
        Document document = this.getDocument();
        Element pageTypesEl = document.getRootElement().element(_PAGE_TYPES_ELEMENT);
        if (pageTypesEl == null) {
            pageTypesEl = document.getRootElement().addElement(_PAGE_TYPES_ELEMENT);
        }
        Element theElement = null;
        List pageTypes = pageTypesEl.elements(_PAGE_TYPE_ELEMENT);
        for (int i = 0; i < pageTypes.size(); ++i) {
            Element pageType = (Element)pageTypes.get(i);
            String id = pageType.elementText(_ID_ELEMENT);
            if (id == null || !id.equals(pageTypeId)) continue;
            theElement = pageType;
        }
        if (theElement != null) {
            theElement = pageTypesEl.addElement(_PAGE_TYPE_ELEMENT);
        }
        Element idElement = theElement.addElement(_ID_ELEMENT);
        idElement.setText(pageTypeId);
        Element pageInstanceIdElement = theElement.addElement(_PAGE_INSTANCE_ID_ELEMENT);
        pageInstanceIdElement.setText(pageId);
        this.updateXML(document);
    }
}

