/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Scriptable;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Chrome;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.ComponentType;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.ContentAssociation;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.PageAssociation;
import org.springframework.extensions.surf.types.PageType;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.TemplateType;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.surf.util.DataUtil;
import org.springframework.extensions.surf.util.EncodingUtil;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.webscripts.ArgumentTypeDescription;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.GUID;
import org.springframework.extensions.webscripts.NegotiatedFormat;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.ScriptCredentialVault;
import org.springframework.extensions.webscripts.ScriptHelper;
import org.springframework.extensions.webscripts.ScriptModelObject;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.ScriptWidgetUtils;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.User;

public final class ScriptSiteData
extends ScriptBase {
    private static final long serialVersionUID = 3903403611285316447L;
    private static Log logger = LogFactory.getLog(ScriptSiteData.class);
    private static final String WEBSCRIPTS_REGISTRY = "webscripts.registry";
    private ApplicationContext applicationContext;

    public ScriptSiteData(RequestContext context, ApplicationContext applicationContext) {
        super(context);
        this.applicationContext = applicationContext;
    }

    public ScriptableMap buildProperties() {
        return null;
    }

    public ScriptModelObject getRootPage() {
        Page modelObject = this.context.getRootPage();
        return ScriptHelper.toScriptModelObject(this.context, modelObject);
    }

    public ScriptModelObject getSiteConfiguration() {
        Configuration modelObject = this.context.getSiteConfiguration();
        return ScriptHelper.toScriptModelObject(this.context, modelObject);
    }

    public String[] getObjectTypeIds() {
        return this.getConfig().getTypeIds();
    }

    public String getObjectTypeName(String objectTypeId) {
        String objectTypeName = null;
        WebFrameworkConfigElement.TypeDescriptor typeDescriptor = this.getConfig().getTypeDescriptor(objectTypeId);
        if (typeDescriptor != null) {
            objectTypeName = typeDescriptor.getName();
        }
        return objectTypeName;
    }

    public String getObjectTypeDescription(String objectTypeId) {
        String objectTypeDescription = null;
        WebFrameworkConfigElement.TypeDescriptor typeDescriptor = this.getConfig().getTypeDescriptor(objectTypeId);
        if (typeDescriptor != null) {
            objectTypeDescription = typeDescriptor.getDescription();
        }
        return objectTypeDescription;
    }

    public Object[] getObjects(String objectTypeId) {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findObjects(objectTypeId));
    }

    public Object[] getChrome() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findChrome());
    }

    public Object[] getComponents() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findComponents());
    }

    public Object[] getComponentTypes() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findComponentTypes());
    }

    public Object[] getConfigurations() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findConfigurations());
    }

    public Object[] getContentAssociations() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findContentAssociations());
    }

    public Object[] getPages() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findPages());
    }

    public Object[] getPageTypes() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findPageTypes());
    }

    public Object[] getPageAssociations() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findPageAssociations());
    }

    public Object[] getTemplates() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findTemplates());
    }

    public Object[] getTemplateTypes() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findTemplateTypes());
    }

    public Object[] getThemes() {
        return ScriptHelper.toScriptModelObjectArray(this.context, this.getObjectService().findThemes());
    }

    public Scriptable getObjectsMap(String objectTypeId) {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findObjects(objectTypeId));
    }

    public Scriptable getChromeMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findChrome());
    }

    public Scriptable getComponentsMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findComponents());
    }

    public Scriptable getComponentTypesMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findComponentTypes());
    }

    public Scriptable getConfigurationsMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findConfigurations());
    }

    public Scriptable getContentAssociationsMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findContentAssociations());
    }

    public Scriptable getPagesMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findPages());
    }

    public Scriptable getPageAssociationsMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findPageAssociations());
    }

    public Scriptable getTemplatesMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findTemplates());
    }

    public Scriptable getTemplateTypesMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findTemplateTypes());
    }

    public Scriptable getThemesMap() {
        return ScriptHelper.toScriptableMap(this.context, this.getObjectService().findThemes());
    }

    public ScriptModelObject newObject(String objectTypeId) {
        ModelObject modelObject = this.getObjectService().newObject(objectTypeId);
        return ScriptHelper.toScriptModelObject(this.context, modelObject);
    }

    public ScriptModelObject newObject(String objectTypeId, String objectId) {
        ModelObject modelObject = this.getObjectService().newObject(objectTypeId, objectId);
        return ScriptHelper.toScriptModelObject(this.context, modelObject);
    }

    public ScriptModelObject newChrome() {
        Chrome chrome = this.getObjectService().newChrome();
        return ScriptHelper.toScriptModelObject(this.context, chrome);
    }

    public ScriptModelObject newComponent() {
        Component component = this.getObjectService().newComponent();
        return ScriptHelper.toScriptModelObject(this.context, component);
    }

    public ScriptModelObject newComponent(String componentTypeId) {
        ParameterCheck.mandatoryString((String)"componentTypeId", (String)componentTypeId);
        Component component = this.getObjectService().newComponent();
        component.setComponentTypeId(componentTypeId);
        return ScriptHelper.toScriptModelObject(this.context, component);
    }

    public ScriptModelObject newComponent(String scope, String regionId, String sourceId) {
        ParameterCheck.mandatoryString((String)"scope", (String)scope);
        ParameterCheck.mandatoryString((String)"regionId", (String)regionId);
        ParameterCheck.mandatoryString((String)"sourceId", (String)sourceId);
        Component component = this.getObjectService().newComponent(scope, regionId, sourceId);
        component.setScope(scope);
        component.setRegionId(regionId);
        component.setSourceId(sourceId);
        return ScriptHelper.toScriptModelObject(this.context, component);
    }

    public ScriptModelObject newComponent(String componentTypeId, String scope, String regionId, String sourceId) {
        ParameterCheck.mandatoryString((String)"componentTypeId", (String)componentTypeId);
        ParameterCheck.mandatoryString((String)"scope", (String)scope);
        ParameterCheck.mandatoryString((String)"regionId", (String)regionId);
        ParameterCheck.mandatoryString((String)"sourceId", (String)sourceId);
        Component component = this.getObjectService().newComponent(scope, regionId, sourceId);
        component.setComponentTypeId(componentTypeId);
        component.setScope(scope);
        component.setRegionId(regionId);
        component.setSourceId(sourceId);
        return ScriptHelper.toScriptModelObject(this.context, component);
    }

    public ScriptModelObject newComponentType() {
        ComponentType modelObject = this.getObjectService().newComponentType();
        return ScriptHelper.toScriptModelObject(this.context, modelObject);
    }

    public ScriptModelObject newConfiguration() {
        Configuration configuration = this.getObjectService().newConfiguration();
        return ScriptHelper.toScriptModelObject(this.context, configuration);
    }

    public ScriptModelObject newConfiguration(String sourceId) {
        ParameterCheck.mandatoryString((String)"sourceId", (String)sourceId);
        Configuration configuration = this.getObjectService().newConfiguration();
        configuration.setSourceId(sourceId);
        return ScriptHelper.toScriptModelObject(this.context, configuration);
    }

    public ScriptModelObject newContentAssociation() {
        ContentAssociation association = this.getObjectService().newContentAssociation();
        return ScriptHelper.toScriptModelObject(this.context, association);
    }

    public ScriptModelObject newPage() {
        Page page = this.getObjectService().newPage();
        return ScriptHelper.toScriptModelObject(this.context, page);
    }

    public ScriptModelObject newPage(String id) {
        ParameterCheck.mandatoryString((String)"id", (String)id);
        Page page = this.getObjectService().newPage(id);
        return ScriptHelper.toScriptModelObject(this.context, page);
    }

    public ScriptModelObject newPage(String id, String title, String description) {
        ParameterCheck.mandatoryString((String)"id", (String)id);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        ParameterCheck.mandatoryString((String)"description", (String)description);
        Page page = this.getObjectService().newPage(id);
        page.setTitle(title);
        page.setDescription(description);
        return ScriptHelper.toScriptModelObject(this.context, page);
    }

    public ScriptModelObject newPage(String id, String title, String titleId, String description, String descriptionId) {
        ParameterCheck.mandatoryString((String)"id", (String)id);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        ParameterCheck.mandatoryString((String)"description", (String)description);
        Page page = this.getObjectService().newPage(id);
        page.setTitle(title);
        page.setDescription(description);
        page.setTitleId(titleId);
        page.setDescriptionId(descriptionId);
        return ScriptHelper.toScriptModelObject(this.context, page);
    }

    public ScriptModelObject newPageAssociation() {
        PageAssociation association = this.getObjectService().newPageAssociation();
        return ScriptHelper.toScriptModelObject(this.context, association);
    }

    public ScriptModelObject newPageType(String objectId) {
        PageType pageType = this.getObjectService().newPageType(objectId);
        return ScriptHelper.toScriptModelObject(this.context, pageType);
    }

    public ScriptModelObject newTemplate() {
        TemplateInstance template = this.getObjectService().newTemplate();
        return ScriptHelper.toScriptModelObject(this.context, template);
    }

    public ScriptModelObject newTemplate(String templateTypeId) {
        ParameterCheck.mandatoryString((String)"templateTypeId", (String)templateTypeId);
        TemplateInstance template = this.getObjectService().newTemplate();
        template.setTemplateTypeId(templateTypeId);
        return ScriptHelper.toScriptModelObject(this.context, template);
    }

    public ScriptModelObject newTemplate(String templateTypeId, String title, String description) {
        ParameterCheck.mandatoryString((String)"templateTypeId", (String)templateTypeId);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        ParameterCheck.mandatoryString((String)"description", (String)description);
        TemplateInstance template = this.getObjectService().newTemplate();
        template.setTemplateTypeId(templateTypeId);
        template.setTitle(title);
        template.setDescription(description);
        return ScriptHelper.toScriptModelObject(this.context, template);
    }

    public ScriptModelObject newTemplate(String templateTypeId, String title, String titleId, String description, String descriptionId) {
        ParameterCheck.mandatoryString((String)"templateTypeId", (String)templateTypeId);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        ParameterCheck.mandatoryString((String)"description", (String)description);
        TemplateInstance template = this.getObjectService().newTemplate();
        template.setTemplateTypeId(templateTypeId);
        template.setTitle(title);
        template.setTitleId(titleId);
        template.setDescription(description);
        template.setDescriptionId(descriptionId);
        return ScriptHelper.toScriptModelObject(this.context, template);
    }

    public ScriptModelObject newTemplateType(String objectId) {
        TemplateType templateType = this.getObjectService().newTemplateType(objectId);
        return ScriptHelper.toScriptModelObject(this.context, templateType);
    }

    public ScriptModelObject newTheme(String objectId) {
        Theme theme = this.getObjectService().newTheme(objectId);
        return ScriptHelper.toScriptModelObject(this.context, theme);
    }

    public boolean newPreset(String presetId, Scriptable tokens) throws ModelObjectPersisterException {
        ParameterCheck.mandatoryString((String)"presetId", (String)presetId);
        Map t = null;
        Object val = ScriptValueConverter.unwrapValue((Object)tokens);
        if (val instanceof Map) {
            t = (Map)val;
        }
        return FrameworkUtil.getServiceRegistry().getPresetsManager().constructPreset(presetId, t);
    }

    public Object[] findComponents(String scope, String regionId, String sourceId, String componentTypeId) {
        Map<String, ModelObject> objects = this.getObjectService().findComponents(scope, regionId, sourceId, componentTypeId);
        return ScriptHelper.toScriptModelObjectArray(this.context, objects);
    }

    public Object[] findWebScripts(String family) {
        ArrayList<ScriptWebScript> values = new ArrayList<ScriptWebScript>(16);
        Registry registry = (Registry)this.applicationContext.getBean(WEBSCRIPTS_REGISTRY);
        for (WebScript webscript : registry.getWebScripts()) {
            if (family != null) {
                Set familys = webscript.getDescription().getFamilys();
                if (familys == null || !familys.contains(family)) continue;
                values.add(new ScriptWebScript(webscript.getDescription()));
                continue;
            }
            values.add(new ScriptWebScript(webscript.getDescription()));
        }
        return values.toArray(new Object[values.size()]);
    }

    public Object[] findChildPageAssociations(String sourceId, String destId) {
        return this.findPageAssociations(sourceId, destId, "child");
    }

    public Object[] findPageAssociations(String sourceId, String destId, String associationType) {
        Map<String, ModelObject> objects = this.getObjectService().findPageAssociations(sourceId, destId, associationType);
        return ScriptHelper.toScriptModelObjectArray(this.context, objects);
    }

    public Object[] findChildPages(String sourceId) {
        Map<String, ModelObject> pageAssociations = this.getObjectService().findPageAssociations(sourceId, null, "child");
        ArrayList<Page> list = new ArrayList<Page>(16);
        for (PageAssociation pageAssociation : pageAssociations.values()) {
            Page page = pageAssociation.getDestPage(this.context);
            if (page != null) {
                list.add(page);
                continue;
            }
            logger.debug((Object)("Unable to find page object for page association id: " + pageAssociation.getId()));
        }
        ModelObject[] modelObjectArray = list.toArray(new Page[list.size()]);
        return ScriptHelper.toScriptModelObjectArray(this.context, modelObjectArray);
    }

    public Object[] findParentPages(String pageId) {
        Map<String, ModelObject> pageAssociations = this.getObjectService().findPageAssociations(null, pageId, "child");
        ArrayList<Page> list = new ArrayList<Page>(16);
        for (PageAssociation pageAssociation : pageAssociations.values()) {
            Page page = pageAssociation.getSourcePage(this.context);
            if (page != null) {
                list.add(page);
                continue;
            }
            logger.debug((Object)("Unable to find page object for page association id: " + pageAssociation.getId()));
        }
        ModelObject[] modelObjectArray = list.toArray(new Page[list.size()]);
        return ScriptHelper.toScriptModelObjectArray(this.context, modelObjectArray);
    }

    public Object[] findContentAssociations(String sourceId, String sourceType, String destId, String assocType, String formatId) {
        Map<String, ModelObject> objects = this.getObjectService().findContentAssociations(sourceId, sourceType, destId, assocType, formatId);
        return ScriptHelper.toScriptModelObjectArray(this.context, objects);
    }

    public Scriptable findComponentsMap(String scope, String regionId, String sourceId, String componentTypeId) {
        Map<String, ModelObject> objects = this.getObjectService().findComponents(scope, regionId, sourceId, componentTypeId);
        return ScriptHelper.toScriptableMap(this.context, objects);
    }

    public Scriptable findPageAssociationsMap(String sourceId, String destId, String associationType) {
        Map<String, ModelObject> objects = this.getObjectService().findPageAssociations(sourceId, destId, associationType);
        return ScriptHelper.toScriptableMap(this.context, objects);
    }

    public Scriptable findContentAssociationsMap(String sourceId, String sourceType, String destId, String assocType, String formatId) {
        Map<String, ModelObject> objects = this.getObjectService().findContentAssociations(sourceId, sourceType, destId, assocType, formatId);
        return ScriptHelper.toScriptableMap(this.context, objects);
    }

    public Scriptable findTemplatesMap(String pageId) {
        Page page = this.getObjectService().getPage(pageId);
        if (page != null) {
            Map<String, TemplateInstance> templatesMap = page.getTemplates(this.context);
            ScriptableLinkedHashMap map = new ScriptableLinkedHashMap(templatesMap.size());
            for (String formatId : templatesMap.keySet()) {
                TemplateInstance template = templatesMap.get(formatId);
                ScriptModelObject scriptModelObject = ScriptHelper.toScriptModelObject(this.context, template);
                map.put((Object)formatId, (Object)scriptModelObject);
            }
            return map;
        }
        return null;
    }

    public ScriptModelObject findConfiguration(String sourceId) {
        ScriptModelObject scriptModelObject = null;
        Map<String, ModelObject> objects = this.getObjectService().findConfigurations(sourceId);
        if (objects.size() > 0) {
            ModelObject object = objects.values().iterator().next();
            scriptModelObject = ScriptHelper.toScriptModelObject(this.context, object);
        }
        return scriptModelObject;
    }

    public ScriptModelObject findTemplate(String pageId) {
        return this.findTemplate(pageId, null);
    }

    public ScriptModelObject findTemplate(String pageId, String formatId) {
        TemplateInstance t;
        Page page = this.getObjectService().getPage(pageId);
        if (page != null && (t = page.getTemplate(this.context, formatId)) != null) {
            return ScriptHelper.toScriptModelObject(this.context, t);
        }
        return null;
    }

    public void removeTemplate(String pageId, String formatId) throws ModelObjectPersisterException {
        Page page = this.getObjectService().getPage(pageId);
        if (page != null) {
            page.removeTemplateId(formatId);
            this.getObjectService().saveObject(page);
        }
    }

    public void bindComponent(String componentId, String scope, String regionId, String sourceId) throws ModelObjectPersisterException {
        this.getObjectService().bindComponent(componentId, scope, regionId, sourceId);
    }

    public void bindComponent(ScriptModelObject componentObject, String scope, String regionId, String sourceId) throws ModelObjectPersisterException {
        Component component = (Component)componentObject.getModelObject();
        this.getObjectService().bindComponent(component, scope, regionId, sourceId);
    }

    public void unbindComponent(String componentId) {
        this.getObjectService().unbindComponent(componentId);
    }

    public void unbindComponent(String scope, String regionId, String sourceId) {
        this.getObjectService().unbindComponent(scope, regionId, sourceId);
    }

    public void associateTemplate(String templateId, String pageId) throws ModelObjectPersisterException {
        this.associateTemplate(templateId, pageId, null);
    }

    public void associateTemplate(String templateId, String pageId, String formatId) throws ModelObjectPersisterException {
        this.getObjectService().associateTemplate(templateId, pageId, formatId);
    }

    public void unassociateTemplate(String pageId) throws ModelObjectPersisterException {
        this.unassociateTemplate(pageId, null);
    }

    public void unassociateTemplate(String pageId, String formatId) throws ModelObjectPersisterException {
        this.getObjectService().unassociateTemplate(pageId, formatId);
    }

    public void associatePage(String sourceId, String destId) throws ModelObjectPersisterException {
        this.getObjectService().associatePage(sourceId, destId);
    }

    public void unassociatePage(String sourceId, String destId) {
        this.getObjectService().unassociatePage(sourceId, destId);
    }

    public void associateContent(String contentId, String templateId, String assocType, String formatId) throws ModelObjectPersisterException {
        if (assocType == null) {
            assocType = "template";
        }
        this.getObjectService().associateContent(contentId, "instance", templateId, assocType, formatId);
    }

    public void unassociateContent(String contentId, String templateId, String formatId) {
        this.getObjectService().unassociateContent(contentId, "instance", templateId, null, formatId);
    }

    public void associateContentType(String contentTypeId, String templateId, String assocType, String formatId) throws ModelObjectPersisterException {
        if (assocType == null) {
            assocType = "template";
        }
        this.getObjectService().associateContent(contentTypeId, "type", templateId, assocType, formatId);
    }

    public void unassociateContentType(String contentTypeId, String templateId, String formatId) {
        this.getObjectService().unassociateContent(contentTypeId, "type", templateId, null, formatId);
    }

    public String encode(String input) {
        return EncodingUtil.encode(input);
    }

    public String encode(String input, String encoding) {
        return EncodingUtil.encode(input, encoding);
    }

    public String decode(String input) {
        return EncodingUtil.decode(input);
    }

    public String decode(String input, String encoding) {
        return EncodingUtil.decode(input, encoding);
    }

    public void logout() {
        AuthenticationUtil.logout(ServletUtil.getRequest(), null);
    }

    public void reloadUser() {
        HttpServletRequest request = ServletUtil.getRequest();
        try {
            FrameworkUtil.getServiceRegistry().getUserFactory().initialiseUser(this.context, request, true);
        }
        catch (UserFactoryException ufe) {
            logger.warn((Object)"Unable to reload current user into session");
        }
    }

    public ScriptCredentialVault getCredentialVault() {
        CredentialVault vault = this.context.getCredentialVault();
        User user = this.context.getUser();
        return new ScriptCredentialVault(vault, user);
    }

    public ScriptModelObject getChrome(String objectId) {
        Chrome obj = this.getObjectService().getChrome(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getComponent(String objectId) {
        Component obj = this.getObjectService().getComponent(objectId);
        if (obj == null && objectId.contains("#")) {
            obj = this.getObjectService().getComponent(objectId.substring(0, objectId.lastIndexOf("#")));
        }
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getComponent(String scope, String regionId, String sourceId) {
        Component obj = this.getObjectService().getComponent(scope, regionId, sourceId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getComponentType(String objectId) {
        ComponentType obj = this.getObjectService().getComponentType(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getConfiguration(String objectId) {
        Configuration obj = this.getObjectService().getConfiguration(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getContentAssociation(String objectId) {
        ContentAssociation obj = this.getObjectService().getContentAssociation(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getPage(String objectId) {
        Page obj = this.getObjectService().getPage(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getPageType(String objectId) {
        PageType obj = this.getObjectService().getPageType(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getPageAssociation(String objectId) {
        PageAssociation obj = this.getObjectService().getPageAssociation(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getTemplate(String objectId) {
        TemplateInstance obj = this.getObjectService().getTemplate(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getTemplateType(String objectId) {
        TemplateType obj = this.getObjectService().getTemplateType(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject getTheme(String objectId) {
        Theme obj = this.getObjectService().getTheme(objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public String newGUID() {
        return new GUID().toString();
    }

    public String[] getFormatIds() {
        return this.getConfig().getFormatIds();
    }

    public String getFormatTitle(String formatId) {
        return this.getConfig().getFormatDescriptor(formatId).getName();
    }

    public String getFormatDescription(String formatId) {
        return this.getConfig().getFormatDescriptor(formatId).getDescription();
    }

    @ScriptMethod(help="Finds an object with the supplied id that matches the supplied value.", output="Freemarker node model")
    public Object findObject(Object o, String targetAttributeKey, String targetAttributeValue) {
        o = ScriptWidgetUtils.findObject(o, targetAttributeKey, targetAttributeValue);
        return o;
    }

    @ScriptMethod(help="Deletes an object with the supplied id that matches the supplied value.", output="Freemarker node model")
    public Object deleteObjectFromArray(Object o, String targetAttributeKey, String targetAttributeValue) {
        o = ScriptWidgetUtils.deleteObjectFromArray(o, targetAttributeKey, targetAttributeValue);
        return o;
    }

    @ScriptMethod(help="Finds the location of the supplied Dojo package as configured in Surf", output="String")
    public String getDojoPackageLocation(String name) {
        String dojoPackage;
        Object location = "-UNKNOWN-DOJO-PACKAGE-";
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        ScriptConfigModel config = rc.getExtendedScriptConfigModel(null);
        WebFrameworkConfigElement wfce = null;
        Map configs = (Map)config.getScoped().get("WebFramework");
        wfce = configs != null ? (WebFrameworkConfigElement)configs.get("web-framework") : this.getConfig();
        Map<String, String> dojoPackages = wfce.getDojoPackages();
        if (dojoPackages != null && (dojoPackage = dojoPackages.get(name)) != null) {
            location = wfce.getDojoBaseUrl() + dojoPackage;
        }
        return location;
    }

    public static class ScriptWebScript {
        private Description description;

        ScriptWebScript(Description description) {
            this.description = description;
        }

        public ArgumentTypeDescription[] getArguments() {
            return this.description.getArguments();
        }

        public String getDefaultFormat() {
            return this.description.getDefaultFormat();
        }

        public String getDescDocument() {
            try {
                return DataUtil.copyToString(this.description.getDescDocument(), "UTF-8", true);
            }
            catch (IOException e) {
                return "";
            }
        }

        public String getDescPath() {
            return this.description.getDescPath();
        }

        public Map<String, Serializable> getExtensions() {
            return this.description.getExtensions();
        }

        public String[] getFamilys() {
            ArrayList<String> familys = new ArrayList<String>(4);
            for (String f : this.description.getFamilys()) {
                familys.add(f);
            }
            return familys.toArray(new String[familys.size()]);
        }

        public String getFormatStyle() {
            return this.description.getFormatStyle().toString();
        }

        public String getKind() {
            return this.description.getKind();
        }

        public String getLifecycle() {
            return this.description.getLifecycle().toString();
        }

        public String getMethod() {
            return this.description.getMethod();
        }

        public boolean getMultipartProcessing() {
            return this.description.getMultipartProcessing();
        }

        public NegotiatedFormat[] getNegotiatedFormats() {
            return this.description.getNegotiatedFormats();
        }

        public Path getPackage() {
            return this.description.getPackage();
        }

        public TypeDescription[] getRequestTypes() {
            return this.description.getRequestTypes();
        }

        public String getRequiredAuthentication() {
            return this.description.getRequiredAuthentication().toString();
        }

        public Description.RequiredCache getRequiredCache() {
            return this.description.getRequiredCache();
        }

        public String getRequiredTransaction() {
            return this.description.getRequiredTransaction().toString();
        }

        public Description.RequiredTransactionParameters getRequiredTransactionParameters() {
            return this.description.getRequiredTransactionParameters();
        }

        public TypeDescription[] getResponseTypes() {
            return this.description.getResponseTypes();
        }

        public String getRunAs() {
            return this.description.getRunAs();
        }

        public String getScriptPath() {
            return this.description.getScriptPath();
        }

        public String getStorePath() {
            return this.description.getStorePath();
        }

        public String[] getURIs() {
            return this.description.getURIs();
        }

        public String getDescription() {
            return this.description.getDescription();
        }

        public String getId() {
            return this.description.getId();
        }

        public String getShortName() {
            return this.description.getShortName();
        }
    }
}

