/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.AbstractExtensibilityDirective;

public abstract class AbstractDependencyExtensibilityDirective
extends AbstractExtensibilityDirective {
    private static final String RES = "/res/";
    private WebFrameworkConfigElement webFrameworkConfig;
    protected DependencyHandler dependencyHandler;
    protected DependencyAggregator dependencyAggregator;
    private RequestContext requestContext;
    private ModelObject modelObject;

    public AbstractDependencyExtensibilityDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    protected String getResourceControllerMapping() {
        return RES;
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.webFrameworkConfig;
    }

    public void setWebFrameworkConfig(WebFrameworkConfigElement webFrameworkConfig) {
        this.webFrameworkConfig = webFrameworkConfig;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setModelObject(ModelObject object) {
        this.modelObject = object;
    }

    public ModelObject getModelObject() {
        return this.modelObject;
    }

    public ProcessedDependency processDependency(String src) {
        String toInsert = "";
        int resIndex = src.indexOf(this.getResourceControllerMapping());
        if (resIndex != -1) {
            String toRemove = src.substring(0, resIndex + this.getResourceControllerMapping().length());
            src = src.substring(toRemove.length());
            toInsert = toRemove;
            if (src.startsWith("/")) {
                src = src.substring(1);
            }
        }
        return new ProcessedDependency(src, toInsert);
    }

    protected String getUpdatedSrc(ProcessedDependency pd) {
        return pd.getUpdatedSrc();
    }

    protected String getToInsert(ProcessedDependency pd) {
        return pd.getToInsert();
    }

    public class ProcessedDependency {
        private String updatedSrc = "";
        private String toInsert = "";

        protected ProcessedDependency(String updatedSrc, String toInsert) {
            this.updatedSrc = updatedSrc;
            this.toInsert = toInsert;
        }

        public String getUpdatedSrc() {
            return this.updatedSrc;
        }

        public String getToInsert() {
            return this.toInsert;
        }

        public String toString() {
            return "ProcessedDependency [updatedSrc=" + this.updatedSrc + ", toInsert=" + this.toInsert + "]";
        }
    }
}

