/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.impl.DefaultContentModelElement;

public class DependencyDeferredContentSourceModelElement
extends DefaultContentModelElement
implements DeferredContentSourceModelElement {
    private boolean removed = false;
    private String dependency;
    private String group;
    private boolean aggregate = false;
    private DeferredContentTargetModelElement targetElement;

    public void markAsRemoved() {
        this.removed = true;
    }

    public boolean hasBeenRemoved() {
        return this.removed;
    }

    public DependencyDeferredContentSourceModelElement(String id, String directiveName, String dependency, String group, boolean aggregate, DeferredContentTargetModelElement targetElement) {
        super(id, directiveName);
        this.group = group;
        this.targetElement = targetElement;
        this.dependency = dependency;
        this.aggregate = aggregate;
    }

    public String getDependency() {
        return this.dependency;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public DeferredContentTargetModelElement getTargetElement() {
        return this.targetElement;
    }

    public void enterEditMode(String mode) {
        DeferredContentTargetModelElement targetElement;
        if (mode == "remove" || mode == "replace") {
            this.markAsRemoved();
        }
        if ((targetElement = this.getTargetElement()) != null) {
            targetElement.enterEditMode(mode, (DeferredContentSourceModelElement)this);
        }
    }

    public void exitEditMode() {
        DeferredContentTargetModelElement targetElement = this.getTargetElement();
        if (targetElement != null) {
            targetElement.exitEditMode();
        }
    }

    public String toString() {
        return "DependencyDeferredContentSourceModelElement [dependency=" + this.dependency + ", group=" + this.group + ", targetElement=" + String.valueOf(this.targetElement) + "]";
    }
}

