/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.uri.UriTemplateListIndex;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.URLHelperFactory;
import org.springframework.extensions.webscripts.servlet.mvc.AbstractWebScriptViewResolver;

public abstract class AbstractWebFrameworkViewResolver
extends AbstractWebScriptViewResolver
implements BeanNameAware {
    private static Log logger = LogFactory.getLog(AbstractWebFrameworkViewResolver.class);
    private TemplatesContainer templatesContainer;
    private WebFrameworkConfigElement webframeworkConfigElement;
    private WebFrameworkServiceRegistry webFrameworkServiceRegistry;
    private ModelObjectService modelObjectService;
    private RenderService webFrameworkRenderService;
    private ResourceService webFrameworkResourceService;
    private URLHelperFactory urlHelperFactory;
    private String beanName;
    private UriTemplateListIndex uriTemplateIndex = null;
    private List<String> prefixes = new ArrayList<String>();
    private List<String> reqParms = new ArrayList<String>();

    public UriTemplateListIndex getUriTemplateListIndex() {
        return this.uriTemplateIndex;
    }

    public void setUriTemplateIndex(UriTemplateListIndex uriTemplateIndex) {
        this.uriTemplateIndex = uriTemplateIndex;
    }

    public AbstractWebFrameworkViewResolver() {
        Class viewClass = this.requiredViewClass();
        this.setViewClass(viewClass);
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
    }

    public void addReqParm(String reqParm) {
        this.reqParms.add(reqParm);
    }

    public String processView(String viewName) {
        String id = null;
        if (this.prefixes != null) {
            for (String currPrefix : this.prefixes) {
                if (!viewName.startsWith(currPrefix)) continue;
                id = viewName.substring(currPrefix.length());
                break;
            }
        } else {
            logger.warn((Object)("No valid prefixes were provided by class: " + ((Object)((Object)this)).getClass().getName()));
        }
        if (this.reqParms != null) {
            RequestContext context = null;
            if (id == null) {
                context = ThreadLocalRequestContext.getRequestContext();
            }
            Iterator<String> reqParmIterator = this.reqParms.iterator();
            while (id == null && reqParmIterator.hasNext()) {
                id = context.getParameter(reqParmIterator.next());
            }
        } else {
            logger.warn((Object)("No valid request parameters were provided by class: " + ((Object)((Object)this)).getClass().getName()));
        }
        return id;
    }

    protected Page lookupPage(String pageId) {
        Page page = this.modelObjectService.getPage(pageId);
        if (page == null) {
            TemplateProcessor templateProcessor;
            TemplateProcessorRegistry templateProcessorRegistry;
            String validTemplatePath;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed get page from ModelObjectService with id: " + pageId));
            }
            if ((validTemplatePath = (templateProcessorRegistry = this.templatesContainer.getTemplateProcessorRegistry()).findValidTemplatePath(pageId)) != null && (templateProcessor = templateProcessorRegistry.getTemplateProcessor(validTemplatePath)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found template that matches missing page id - will create temp page to match.");
                }
                TemplateInstance templateInstance = this.modelObjectService.newTemplate(pageId);
                templateInstance.setTemplateTypeId(pageId);
                page = this.modelObjectService.newPage(pageId);
                page.setTemplateId(pageId);
            }
        }
        return page;
    }

    public Map<String, String> matchUriTemplate(String uri) {
        Map<String, String> tokens = null;
        if (this.uriTemplateIndex != null) {
            tokens = this.uriTemplateIndex.findMatch(uri);
            ThreadLocalRequestContext.getRequestContext().setUriTokens(tokens);
        }
        return tokens;
    }

    public UriTemplateListIndex generateUriTemplateListIndexFromConfig(WebFrameworkServiceRegistry serviceRegistry, String targetElement) {
        ConfigElement uriConfig;
        UriTemplateListIndex uriTemplateIndex = null;
        Config config = serviceRegistry.getConfigService().getConfig((Object)"UriTemplate");
        if (config != null && (uriConfig = config.getConfigElement(targetElement)) != null) {
            uriTemplateIndex = new UriTemplateListIndex(uriConfig);
        }
        return uriTemplateIndex;
    }

    protected boolean canHandle(String viewName, Locale locale) {
        Map<String, String> uriTokens;
        boolean canHandle = false;
        Object uri = this.processView(viewName);
        if (uri != null && (uriTokens = this.matchUriTemplate((String)(uri = "/" + (String)uri))) != null) {
            canHandle = true;
        }
        return canHandle;
    }

    public TemplatesContainer getTemplatesContainer() {
        return this.templatesContainer;
    }

    public void setTemplatesContainer(TemplatesContainer templatesContainer) {
        this.templatesContainer = templatesContainer;
    }

    public WebFrameworkConfigElement getWebframeworkConfigElement() {
        return this.webframeworkConfigElement;
    }

    public void setWebframeworkConfigElement(WebFrameworkConfigElement webframeworkConfigElement) {
        this.webframeworkConfigElement = webframeworkConfigElement;
    }

    public WebFrameworkServiceRegistry getWebFrameworkServiceRegistry() {
        return this.webFrameworkServiceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.webFrameworkServiceRegistry;
    }

    public void setServiceRegistry(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        this.webFrameworkServiceRegistry = webFrameworkServiceRegistry;
    }

    public ModelObjectService getModelObjectService() {
        return this.modelObjectService;
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public RenderService getWebFrameworkRenderService() {
        return this.webFrameworkRenderService;
    }

    public void setWebFrameworkRenderService(RenderService webFrameworkRenderService) {
        this.webFrameworkRenderService = webFrameworkRenderService;
    }

    public ResourceService getWebFrameworkResourceService() {
        return this.webFrameworkResourceService;
    }

    public void setWebFrameworkResourceService(ResourceService webFrameworkResourceService) {
        this.webFrameworkResourceService = webFrameworkResourceService;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public URLHelperFactory getUrlHelperFactory() {
        return this.urlHelperFactory;
    }

    public void setUrlHelperFactory(URLHelperFactory urlHelperFactory) {
        this.urlHelperFactory = urlHelperFactory;
    }
}

